/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v1_0.JmsMessageTypeAnnotation;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_to_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionEncoder;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequence;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValue;
import org.apache.qpid.server.protocol.v1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Data;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.server.protocol.v1_0.type.messaging.NonEncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

@PluggableService
public class MessageConverter_Internal_to_v1_0
extends MessageConverter_to_1_0<InternalMessage> {
    private static final Set<Class<?>> TYPES_EXPRESSIBLE_AS_AMQP_1_0_VALUE = Set.of(String.class, Character.class, Boolean.class, Number.class, UUID.class, Date.class);

    public Class<InternalMessage> getInputClass() {
        return InternalMessage.class;
    }

    @Override
    protected MessageMetaData_1_0 convertMetaData(InternalMessage serverMessage, EncodingRetainingSection<?> bodySection, SectionEncoder sectionEncoder) {
        Header header = new Header();
        header.setDurable(serverMessage.isPersistent());
        header.setPriority(UnsignedByte.valueOf(serverMessage.getMessageHeader().getPriority()));
        if (serverMessage.getExpiration() != 0L && serverMessage.getArrivalTime() != 0L && serverMessage.getExpiration() >= serverMessage.getArrivalTime()) {
            header.setTtl(UnsignedInteger.valueOf(serverMessage.getExpiration() - serverMessage.getArrivalTime()));
        }
        Properties properties = new Properties();
        if (serverMessage.getMessageHeader().getEncoding() != null) {
            properties.setContentEncoding(Symbol.valueOf(serverMessage.getMessageHeader().getEncoding()));
        }
        properties.setCorrelationId(this.getCorrelationId(serverMessage));
        properties.setCreationTime(new Date(serverMessage.getMessageHeader().getTimestamp()));
        properties.setMessageId(this.getMessageId(serverMessage));
        Symbol contentType = this.getContentTypeSymbol(serverMessage.getMessageBody(), serverMessage.getMessageHeader().getMimeType());
        properties.setContentType(contentType);
        String userId = serverMessage.getMessageHeader().getUserId();
        if (userId != null) {
            properties.setUserId(new Binary(userId.getBytes(StandardCharsets.UTF_8)));
        }
        properties.setReplyTo(serverMessage.getMessageHeader().getReplyTo());
        properties.setTo(serverMessage.getTo());
        ApplicationProperties applicationProperties = null;
        if (!serverMessage.getMessageHeader().getHeaderNames().isEmpty()) {
            try {
                applicationProperties = new ApplicationProperties(serverMessage.getMessageHeader().getHeaderMap());
            }
            catch (IllegalArgumentException e) {
                throw new MessageConversionException("Could not convert message from internal to 1.0 because conversion of 'application headers' failed.", (Throwable)e);
            }
        }
        MessageAnnotations messageAnnotation = this.createMessageAnnotation(serverMessage.getMessageBody(), serverMessage.getMessageHeader().getMimeType(), bodySection);
        return new MessageMetaData_1_0(header.createEncodingRetainingSection(), null, messageAnnotation == null ? null : messageAnnotation.createEncodingRetainingSection(), properties.createEncodingRetainingSection(), applicationProperties == null ? null : applicationProperties.createEncodingRetainingSection(), null, serverMessage.getArrivalTime(), bodySection.getEncodedSize());
    }

    private MessageAnnotations createMessageAnnotation(Object originalMessageBody, String mimeType, EncodingRetainingSection<?> convertedMessageBody) {
        Object contentTypeAnnotationValue = originalMessageBody instanceof String ? Byte.valueOf(JmsMessageTypeAnnotation.TEXT_MESSAGE.getType()) : (originalMessageBody instanceof List ? (MessageConverter_Internal_to_v1_0.isSectionValidForJmsList(convertedMessageBody) ? Byte.valueOf(JmsMessageTypeAnnotation.STREAM_MESSAGE.getType()) : null) : (originalMessageBody instanceof byte[] ? Byte.valueOf(JmsMessageTypeAnnotation.BYTES_MESSAGE.getType()) : (originalMessageBody instanceof Map ? (MessageConverter_Internal_to_v1_0.isSectionValidForJmsMap(convertedMessageBody) ? Byte.valueOf(JmsMessageTypeAnnotation.MAP_MESSAGE.getType()) : null) : (originalMessageBody != null && TYPES_EXPRESSIBLE_AS_AMQP_1_0_VALUE.stream().anyMatch(clazz -> clazz.isAssignableFrom(originalMessageBody.getClass())) ? null : (originalMessageBody instanceof Serializable ? Byte.valueOf(JmsMessageTypeAnnotation.OBJECT_MESSAGE.getType()) : (originalMessageBody == null && mimeType == null ? Byte.valueOf(JmsMessageTypeAnnotation.MESSAGE.getType()) : null))))));
        if (contentTypeAnnotationValue != null) {
            return new MessageAnnotations(Collections.singletonMap(Symbol.valueOf("x-opt-jms-msg-type"), contentTypeAnnotationValue));
        }
        return null;
    }

    private Symbol getContentTypeSymbol(Object messageBody, String mimeType) {
        Object contentTypeAsString = messageBody instanceof String ? (mimeType == null ? "text/plain" : mimeType) : (messageBody instanceof List ? null : (messageBody instanceof byte[] ? (mimeType == null ? "application/octet-stream" : mimeType) : (messageBody instanceof Map ? null : (messageBody != null && TYPES_EXPRESSIBLE_AS_AMQP_1_0_VALUE.stream().anyMatch(clazz -> clazz.isAssignableFrom(messageBody.getClass())) ? mimeType : (messageBody instanceof Serializable ? "application/x-java-serialized-object" : mimeType)))));
        return Symbol.valueOf((String)contentTypeAsString);
    }

    private Object getMessageId(InternalMessage serverMessage) {
        String messageIdAsString = serverMessage.getMessageHeader().getMessageId();
        return this.stringToMessageId(messageIdAsString);
    }

    private Object getCorrelationId(InternalMessage serverMessage) {
        String correlationIdAsString = serverMessage.getMessageHeader().getCorrelationId();
        return this.stringToMessageId(correlationIdAsString);
    }

    private Object stringToMessageId(String correlationIdAsString) {
        Object messageId = null;
        if (correlationIdAsString != null) {
            try {
                messageId = UUID.fromString(correlationIdAsString);
            }
            catch (IllegalArgumentException e) {
                try {
                    messageId = UnsignedLong.valueOf(correlationIdAsString);
                }
                catch (NumberFormatException nfe) {
                    messageId = correlationIdAsString;
                }
            }
        }
        return messageId;
    }

    @Override
    protected EncodingRetainingSection<?> getBodySection(InternalMessage serverMessage, SectionEncoder encoder) {
        return this.convertToBody(serverMessage.getMessageBody()).createEncodingRetainingSection();
    }

    public String getType() {
        return "Internal to v1-0";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public NonEncodingRetainingSection<?> convertToBody(Object object) {
        if (object == null || TYPES_EXPRESSIBLE_AS_AMQP_1_0_VALUE.stream().anyMatch(clazz -> clazz.isAssignableFrom(object.getClass()))) {
            return new AmqpValue(object);
        }
        if (object instanceof byte[]) {
            return new Data(new Binary((byte[])object));
        }
        if (object instanceof Map) {
            return new AmqpValue(MessageConverter_to_1_0.fixMapValues((Map)object));
        }
        if (object instanceof List) {
            return new AmqpSequence(MessageConverter_to_1_0.fixListValues((List)object));
        }
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            Data data;
            try (ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
                os.writeObject(object);
                data = new Data(new Binary(bytesOut.toByteArray()));
            }
            return data;
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
    }
}

