/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.user.connection.limits.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.security.limit.ConnectionLimitException;
import org.apache.qpid.server.security.limit.ConnectionLimiter;
import org.apache.qpid.server.security.limit.ConnectionSlot;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.user.connection.limits.config.PortConnectionCounter;
import org.apache.qpid.server.user.connection.limits.config.Rule;
import org.apache.qpid.server.user.connection.limits.config.RulePredicates;
import org.apache.qpid.server.user.connection.limits.config.RuleSet;
import org.apache.qpid.server.user.connection.limits.logging.ConnectionLimitEventLogger;
import org.apache.qpid.server.user.connection.limits.logging.FullConnectionLimitEventLogger;
import org.apache.qpid.server.user.connection.limits.outcome.RejectRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RuleSetImpl
implements RuleSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleSet.class);
    private final String _name;
    private final Function<EventLoggerProvider, ConnectionLimitEventLogger> _loggerFactory;
    private final Map<String, PortConnectionCounter> _portConnectionCounters;
    private final Function<String, PortConnectionCounter> _defaultPortConnectionCounterProvider;
    private final AtomicReference<ConnectionLimiter> _appendedLimiter;

    RuleSetImpl(RuleSetBuilderImpl builder) {
        this._name = builder.getName();
        this._loggerFactory = builder.getLoggerFactory();
        this._portConnectionCounters = new ConcurrentHashMap<String, PortConnectionCounter>(builder.getPortConnectionCounters());
        this._defaultPortConnectionCounterProvider = builder.getDefaultPortConnectionCounterProvider();
        this._appendedLimiter = new AtomicReference<ConnectionLimiter.CachedLimiter>(ConnectionLimiter.noLimits());
    }

    private RuleSetImpl(RuleSetImpl ruleSet, ConnectionLimiter limiter) {
        this._name = ruleSet._name;
        this._loggerFactory = ruleSet._loggerFactory;
        this._portConnectionCounters = ruleSet._portConnectionCounters;
        this._defaultPortConnectionCounterProvider = ruleSet._defaultPortConnectionCounterProvider;
        this._appendedLimiter = new AtomicReference<ConnectionLimiter>(limiter);
    }

    public ConnectionSlot register(AMQPConnection<?> connection) {
        try {
            return this._portConnectionCounters.computeIfAbsent(connection.getPort().getName(), this._defaultPortConnectionCounterProvider).register(connection, this._appendedLimiter.get()).logMessage(this._loggerFactory.apply((EventLoggerProvider)connection));
        }
        catch (RejectRegistration result) {
            LOGGER.debug(String.format("Connection limiter %s, user limit exceeded", this._name), (Throwable)((Object)result));
            throw new ConnectionLimitException(result.logMessage(this._loggerFactory.apply((EventLoggerProvider)connection)));
        }
    }

    public ConnectionLimiter append(ConnectionLimiter limiter) {
        return new RuleSetImpl(this, this._appendedLimiter.get().append(limiter));
    }

    public String toString() {
        return this._name;
    }

    static final class RuleSetBuilderImpl
    implements RuleSet.Builder {
        private final String _name;
        private final List<Rule> _forAllPorts = new ArrayList<Rule>();
        private final Duration _defaultFrequencyPeriod;
        private final Map<String, PortConnectionCounter.Builder> _builders;
        private final PortConnectionCounter.Builder _defaultBuilder;
        private Function<EventLoggerProvider, ConnectionLimitEventLogger> _loggerFactory;

        RuleSetBuilderImpl(String name, Duration defaultFrequencyPeriod) {
            this._name = name;
            this._defaultFrequencyPeriod = defaultFrequencyPeriod;
            this._loggerFactory = loggerProvider -> new ConnectionLimitEventLogger(name, (EventLoggerProvider)loggerProvider);
            this._builders = new HashMap<String, PortConnectionCounter.Builder>();
            this._defaultBuilder = PortConnectionCounter.newBuilder(defaultFrequencyPeriod);
        }

        @Override
        public RuleSet.Builder logAllMessages(boolean all) {
            this._loggerFactory = all ? loggerProvider -> new FullConnectionLimitEventLogger(this._name, (EventLoggerProvider)loggerProvider) : loggerProvider -> new ConnectionLimitEventLogger(this._name, (EventLoggerProvider)loggerProvider);
            return this;
        }

        @Override
        public RuleSet.Builder addRule(Rule rule) {
            this.addRuleImpl(rule);
            return this;
        }

        @Override
        public RuleSet.Builder addRules(Collection<? extends Rule> rules) {
            if (rules != null) {
                rules.forEach(this::addRuleImpl);
            }
            return this;
        }

        private void addRuleImpl(Rule rule) {
            if (rule == null) {
                return;
            }
            String port = rule.getPort();
            if (RulePredicates.isAllPort(port)) {
                this._forAllPorts.add(rule);
                this._defaultBuilder.add(rule);
                this._builders.values().forEach(builder -> builder.add(rule));
            } else {
                this._builders.computeIfAbsent(port, portName -> PortConnectionCounter.newBuilder(this._defaultFrequencyPeriod).addAll(this._forAllPorts)).add(rule);
            }
        }

        @Override
        public RuleSet build() {
            return new RuleSetImpl(this);
        }

        Function<EventLoggerProvider, ConnectionLimitEventLogger> getLoggerFactory() {
            return this._loggerFactory;
        }

        Map<String, PortConnectionCounter> getPortConnectionCounters() {
            HashMap<String, PortConnectionCounter> limiters = new HashMap<String, PortConnectionCounter>();
            this._builders.forEach((port, builder) -> limiters.put((String)port, builder.build()));
            return limiters;
        }

        Function<String, PortConnectionCounter> getDefaultPortConnectionCounterProvider() {
            return portName -> this._defaultBuilder.build();
        }

        String getName() {
            return this._name;
        }
    }
}

