/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class OrderByColumn
extends OrderedColumn {
    private ResultColumn resultCol;
    private boolean ascending = true;
    private boolean nullsOrderedLow = false;
    private ValueNode expression;
    private OrderByList list;
    private int addedColumnOffset = -1;

    OrderByColumn(ValueNode valueNode, ContextManager contextManager) {
        super(contextManager);
        this.expression = valueNode;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    void setDescending() {
        this.ascending = false;
    }

    @Override
    boolean isAscending() {
        return this.ascending;
    }

    void setNullsOrderedLow() {
        this.nullsOrderedLow = true;
    }

    @Override
    boolean isNullsOrderedLow() {
        return this.nullsOrderedLow;
    }

    ResultColumn getResultColumn() {
        return this.resultCol;
    }

    ValueNode getNonRedundantExpression() {
        ColumnReference columnReference = null;
        ResultColumn resultColumn = this.resultCol;
        while (resultColumn.isRedundant()) {
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode instanceof ColumnReference) {
                columnReference = (ColumnReference)valueNode;
            }
            resultColumn = columnReference.getSource();
        }
        return resultColumn.getExpression();
    }

    void bindOrderByColumn(ResultSetNode resultSetNode, OrderByList orderByList) throws StandardException {
        this.list = orderByList;
        if (this.expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.expression;
            this.resultCol = this.resolveColumnReference(resultSetNode, columnReference);
            this.columnPosition = this.resultCol.getColumnPosition();
            if (this.addedColumnOffset >= 0 && resultSetNode instanceof SelectNode && ((SelectNode)resultSetNode).hasDistinct()) {
                throw StandardException.newException((String)"42879", (Object[])new Object[]{columnReference.getColumnName()});
            }
        } else if (OrderByColumn.isReferedColByNum(this.expression)) {
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            this.columnPosition = (Integer)this.expression.getConstantValueAsObject();
            this.resultCol = resultColumnList.getOrderByColumn(this.columnPosition);
            if (this.resultCol == null || this.resultCol.getColumnPosition() > resultColumnList.visibleSize()) {
                throw StandardException.newException((String)"42X77", (Object[])new Object[]{String.valueOf(this.columnPosition)});
            }
        } else {
            if (this.list.isTableValueCtorOrdering()) {
                throw StandardException.newException((String)"4287B", (Object[])new Object[0]);
            }
            if (this.addedColumnOffset >= 0 && resultSetNode instanceof SelectNode && ((SelectNode)resultSetNode).hasDistinct() && !this.expressionMatch(resultSetNode)) {
                CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                this.expression.accept(collectNodesVisitor);
                for (ColumnReference columnReference : collectNodesVisitor.getList()) {
                    String string = columnReference.getColumnName();
                    boolean bl = this.columnMatchFound(resultSetNode, columnReference);
                    if (bl) continue;
                    throw StandardException.newException((String)"42879", (Object[])new Object[]{string});
                }
            }
            this.resolveAddedColumn(resultSetNode);
            if (this.resultCol == null) {
                throw StandardException.newException((String)"42878", (Object[])new Object[0]);
            }
        }
        this.resultCol.verifyOrderable();
    }

    private boolean expressionMatch(ResultSetNode resultSetNode) throws StandardException {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        for (int i = 1; i <= resultColumnList.visibleSize(); ++i) {
            if (!resultColumnList.getResultColumn(i).isEquivalent(this.resultCol)) continue;
            return true;
        }
        return false;
    }

    private boolean columnMatchFound(ResultSetNode resultSetNode, ColumnReference columnReference) throws StandardException {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        for (int i = 1; i <= resultColumnList.visibleSize(); ++i) {
            ColumnReference columnReference2;
            ValueNode valueNode = resultColumnList.getResultColumn(i).getExpression();
            if (!(valueNode instanceof ColumnReference) || !columnReference.isEquivalent(columnReference2 = (ColumnReference)valueNode)) continue;
            return true;
        }
        return false;
    }

    private void resolveAddedColumn(ResultSetNode resultSetNode) {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        this.columnPosition = resultColumnList.visibleSize() + this.addedColumnOffset + 1;
        this.resultCol = resultColumnList.getResultColumn(this.columnPosition);
    }

    void pullUpOrderByColumn(ResultSetNode resultSetNode) throws StandardException {
        ResultColumnList resultColumnList = resultSetNode.getResultColumns();
        if (this.expression instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)this.expression;
            this.resultCol = resultColumnList.findResultColumnForOrderBy(columnReference.getColumnName(), columnReference.getQualifiedTableName());
            if (this.resultCol == null) {
                this.resultCol = new ResultColumn(columnReference.getColumnName(), (ValueNode)columnReference, this.getContextManager());
                resultColumnList.addResultColumn(this.resultCol);
                this.addedColumnOffset = resultColumnList.getOrderBySelect();
                resultColumnList.incOrderBySelect();
            }
        } else if (!OrderByColumn.isReferedColByNum(this.expression)) {
            this.resultCol = new ResultColumn((String)null, this.expression, this.getContextManager());
            resultColumnList.addResultColumn(this.resultCol);
            this.addedColumnOffset = resultColumnList.getOrderBySelect();
            resultColumnList.incOrderBySelect();
        }
    }

    void resetToSourceRC() {
        this.resultCol = this.resultCol.getExpression().getSourceResultColumn();
    }

    boolean constantColumn(PredicateList predicateList) {
        ValueNode valueNode = this.resultCol.getExpression();
        return valueNode.constantExpression(predicateList);
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        this.resultCol.setExpression(this.resultCol.getExpression().remapColumnReferencesToExpressions());
    }

    private static boolean isReferedColByNum(ValueNode valueNode) throws StandardException {
        return valueNode instanceof NumericConstantNode && valueNode.getConstantValueAsObject() instanceof Integer;
    }

    private ResultColumn resolveColumnReference(ResultSetNode resultSetNode, ColumnReference columnReference) throws StandardException {
        QueryTreeNode queryTreeNode;
        QueryTreeNode queryTreeNode2;
        int n = -1;
        if (resultSetNode instanceof SetOperatorNode && columnReference.getTableName() != null) {
            String string = columnReference.getSQLColumnName();
            throw StandardException.newException((String)"42877", (Object[])new Object[]{string});
        }
        if (columnReference.getQualifiedTableName() != null) {
            queryTreeNode2 = columnReference.getQualifiedTableName();
            queryTreeNode = resultSetNode.getFromTableByName(((TableName)queryTreeNode2).getTableName(), ((TableName)queryTreeNode2).hasSchema() ? ((TableName)queryTreeNode2).getSchemaName() : null, true);
            if (queryTreeNode == null && (queryTreeNode = resultSetNode.getFromTableByName(((TableName)queryTreeNode2).getTableName(), ((TableName)queryTreeNode2).hasSchema() ? ((TableName)queryTreeNode2).getSchemaName() : null, false)) == null) {
                String string = columnReference.getQualifiedTableName().toString();
                throw StandardException.newException((String)"42X10", (Object[])new Object[]{string});
            }
            n = resultSetNode instanceof SetOperatorNode ? ((FromTable)resultSetNode).getTableNumber() : ((FromTable)queryTreeNode).getTableNumber();
        }
        if ((queryTreeNode = ((ResultColumnList)(queryTreeNode2 = resultSetNode.getResultColumns())).getOrderByColumnToBind(columnReference.getColumnName(), columnReference.getQualifiedTableName(), n, this)) == null && this.addedColumnOffset >= 0) {
            this.resolveAddedColumn(resultSetNode);
        }
        if (queryTreeNode == null || ((ResultColumn)queryTreeNode).isNameGenerated()) {
            String string = columnReference.getColumnName();
            throw StandardException.newException((String)"42X78", (Object[])new Object[]{string});
        }
        return queryTreeNode;
    }

    void clearAddedColumnOffset() {
        this.list.closeGap(this.addedColumnOffset);
        this.addedColumnOffset = -1;
    }

    void collapseAddedColumnGap(int n) {
        if (this.addedColumnOffset > n) {
            --this.addedColumnOffset;
        }
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.expression != null) {
            this.expression = (ValueNode)this.expression.accept(visitor);
        }
    }

    ValueNode getExpression() {
        return this.expression;
    }
}

