/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.security.auth.Subject;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.pool.SuppressingInheritedAccessControlContextThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HousekeepingExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HousekeepingExecutor.class);

    public HousekeepingExecutor(String threadPrefix, int threadCount, Subject subject) {
        super(threadCount, QpidByteBuffer.createQpidByteBufferTrackingThreadFactory(HousekeepingExecutor.createThreadFactory(threadPrefix, threadCount, subject)));
    }

    private static SuppressingInheritedAccessControlContextThreadFactory createThreadFactory(String threadPrefix, int threadCount, Subject subject) {
        return new SuppressingInheritedAccessControlContextThreadFactory(threadPrefix, subject);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future) {
            Future future = (Future)((Object)r);
            try {
                if (future.isDone()) {
                    Object v = future.get();
                }
            }
            catch (CancellationException ce) {
                LOGGER.debug("Housekeeping task got cancelled");
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t1) {
                t = t1;
            }
        }
        if (t != null) {
            LOGGER.error("Housekeeping task threw an exception:", t);
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
            } else {
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

