/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.txn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.txn.DtxBranch;
import org.apache.qpid.server.txn.IncorrectDtxStateException;
import org.apache.qpid.server.txn.RollbackOnlyDtxException;
import org.apache.qpid.server.txn.TimeoutDtxException;
import org.apache.qpid.server.txn.UnknownDtxBranchException;
import org.apache.qpid.server.txn.Xid;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

public class DtxRegistry {
    private final Map<ComparableXid, DtxBranch> _branches = new HashMap<ComparableXid, DtxBranch>();
    private final QueueManagingVirtualHost<?> _virtualHost;

    public DtxRegistry(QueueManagingVirtualHost<?> virtualHost) {
        this._virtualHost = virtualHost;
    }

    public MessageStore getMessageStore() {
        return this._virtualHost.getMessageStore();
    }

    public ScheduledFuture<?> scheduleTask(long delay, Runnable task) {
        return this._virtualHost.scheduleTask(delay, task);
    }

    public synchronized DtxBranch getBranch(Xid xid) {
        return this._branches.get(new ComparableXid(xid));
    }

    public synchronized boolean registerBranch(DtxBranch branch) {
        ComparableXid xid = new ComparableXid(branch.getXid());
        if (!this._branches.containsKey(xid)) {
            this._branches.put(xid, branch);
            return true;
        }
        return false;
    }

    synchronized boolean unregisterBranch(DtxBranch branch) {
        return this._branches.remove(new ComparableXid(branch.getXid())) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Xid id, boolean onePhase) throws IncorrectDtxStateException, UnknownDtxBranchException, StoreException, RollbackOnlyDtxException, TimeoutDtxException {
        DtxBranch branch = this.getBranch(id);
        if (branch != null) {
            DtxBranch dtxBranch = branch;
            synchronized (dtxBranch) {
                if (!branch.hasAssociatedActiveSessions()) {
                    branch.clearAssociations();
                    if (branch.expired() || branch.getState() == DtxBranch.State.TIMEDOUT) {
                        this.unregisterBranch(branch);
                        throw new TimeoutDtxException(id);
                    }
                    if (branch.getState() == DtxBranch.State.ROLLBACK_ONLY) {
                        throw new RollbackOnlyDtxException(id);
                    }
                    if (onePhase && branch.getState() == DtxBranch.State.PREPARED) {
                        throw new IncorrectDtxStateException("Cannot call one-phase commit on a prepared branch", id);
                    }
                    if (!onePhase && branch.getState() != DtxBranch.State.PREPARED) {
                        throw new IncorrectDtxStateException("Cannot call two-phase commit on a non-prepared branch", id);
                    }
                } else {
                    throw new IncorrectDtxStateException("Branch was still associated with a session", id);
                }
                branch.commit();
                branch.setState(DtxBranch.State.FORGOTTEN);
                this.unregisterBranch(branch);
            }
        } else {
            throw new UnknownDtxBranchException(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepare(Xid id) throws UnknownDtxBranchException, IncorrectDtxStateException, StoreException, RollbackOnlyDtxException, TimeoutDtxException {
        DtxBranch branch = this.getBranch(id);
        if (branch != null) {
            DtxBranch dtxBranch = branch;
            synchronized (dtxBranch) {
                if (!branch.hasAssociatedActiveSessions()) {
                    branch.clearAssociations();
                    if (branch.expired() || branch.getState() == DtxBranch.State.TIMEDOUT) {
                        this.unregisterBranch(branch);
                        throw new TimeoutDtxException(id);
                    }
                    if (branch.getState() != DtxBranch.State.ACTIVE && branch.getState() != DtxBranch.State.ROLLBACK_ONLY) {
                        throw new IncorrectDtxStateException("Cannot prepare a transaction in state " + String.valueOf((Object)branch.getState()), id);
                    }
                } else {
                    throw new IncorrectDtxStateException("Branch still has associated sessions", id);
                }
                branch.prepare();
                branch.setState(DtxBranch.State.PREPARED);
            }
        } else {
            throw new UnknownDtxBranchException(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Xid id) throws IncorrectDtxStateException, UnknownDtxBranchException, StoreException, TimeoutDtxException {
        DtxBranch branch = this.getBranch(id);
        if (branch != null) {
            DtxBranch dtxBranch = branch;
            synchronized (dtxBranch) {
                if (branch.expired() || branch.getState() == DtxBranch.State.TIMEDOUT) {
                    this.unregisterBranch(branch);
                    throw new TimeoutDtxException(id);
                }
                if (branch.hasAssociatedActiveSessions()) {
                    throw new IncorrectDtxStateException("Branch was still associated with a session", id);
                }
                branch.clearAssociations();
                branch.rollback();
                branch.setState(DtxBranch.State.FORGOTTEN);
                this.unregisterBranch(branch);
            }
        } else {
            throw new UnknownDtxBranchException(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid id) throws UnknownDtxBranchException, IncorrectDtxStateException {
        DtxBranch branch = this.getBranch(id);
        if (branch != null) {
            DtxBranch dtxBranch = branch;
            synchronized (dtxBranch) {
                if (!branch.hasAssociatedSessions()) {
                    if (branch.getState() != DtxBranch.State.HEUR_COM && branch.getState() != DtxBranch.State.HEUR_RB) {
                        throw new IncorrectDtxStateException("Branch should not be forgotten - it is not heuristically complete", id);
                    }
                } else {
                    throw new IncorrectDtxStateException("Branch was still associated with a session", id);
                }
                branch.setState(DtxBranch.State.FORGOTTEN);
                this.unregisterBranch(branch);
            }
        } else {
            throw new UnknownDtxBranchException(id);
        }
    }

    public long getTimeout(Xid id) throws UnknownDtxBranchException {
        DtxBranch branch = this.getBranch(id);
        if (branch != null) {
            return branch.getTimeout();
        }
        throw new UnknownDtxBranchException(id);
    }

    public void setTimeout(Xid id, long timeout) throws UnknownDtxBranchException {
        DtxBranch branch = this.getBranch(id);
        if (branch == null) {
            throw new UnknownDtxBranchException(id);
        }
        branch.setTimeout(timeout);
    }

    public synchronized List<Xid> recover() {
        ArrayList<Xid> inDoubt = new ArrayList<Xid>();
        for (DtxBranch branch : this._branches.values()) {
            if (branch.getState() != DtxBranch.State.PREPARED) continue;
            inDoubt.add(branch.getXid());
        }
        return inDoubt;
    }

    public synchronized void endAssociations(AMQPSession<?, ?> session) {
        for (DtxBranch branch : this._branches.values()) {
            if (!branch.isAssociated(session)) continue;
            branch.setState(DtxBranch.State.ROLLBACK_ONLY);
            branch.disassociateSession(session);
        }
    }

    public synchronized void close() {
        for (DtxBranch branch : this._branches.values()) {
            branch.close();
        }
        this._branches.clear();
    }

    private static final class ComparableXid {
        private final Xid _xid;

        private ComparableXid(Xid xid) {
            this._xid = xid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparableXid that = (ComparableXid)o;
            return ComparableXid.compareBytes(this._xid.getBranchId(), that._xid.getBranchId()) && ComparableXid.compareBytes(this._xid.getGlobalId(), that._xid.getGlobalId());
        }

        private static boolean compareBytes(byte[] a, byte[] b) {
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int i;
            int result = 0;
            for (i = 0; i < this._xid.getGlobalId().length; ++i) {
                result = 31 * result + this._xid.getGlobalId()[i];
            }
            for (i = 0; i < this._xid.getBranchId().length; ++i) {
                result = 31 * result + this._xid.getBranchId()[i];
            }
            return result;
        }
    }
}

