/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.DurableConfigurationStoreUpgrader;
import org.apache.qpid.server.store.StoreUpgraderPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStoreUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericStoreUpgrader.class);
    private final Map<UUID, ConfiguredObjectRecord> _records = new HashMap<UUID, ConfiguredObjectRecord>();
    private final Map<String, StoreUpgraderPhase> _upgraders;
    private final DurableConfigurationStore _store;
    private final String _rootCategory;
    private final String _modelVersionAttributeName;

    public GenericStoreUpgrader(String rootCategory, String rootModelVersionAttributeName, DurableConfigurationStore configurationStore, Map<String, StoreUpgraderPhase> upgraders) {
        this._upgraders = upgraders;
        this._store = configurationStore;
        this._rootCategory = rootCategory;
        this._modelVersionAttributeName = rootModelVersionAttributeName;
    }

    public List<ConfiguredObjectRecord> getRecords() {
        return new ArrayList<ConfiguredObjectRecord>(this._records.values());
    }

    public void upgrade(List<ConfiguredObjectRecord> records) {
        this._records.clear();
        for (ConfiguredObjectRecord record : records) {
            this._records.put(record.getId(), record);
        }
        this.performUpgrade();
    }

    private void performUpgrade() {
        String version = this.getCurrentVersion();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(this._rootCategory + " store has model version " + version + ". Number of record(s) " + this._records.size());
        }
        HashMap<UUID, ConfiguredObjectRecord> updatedRecords = new HashMap<UUID, ConfiguredObjectRecord>();
        HashMap<UUID, ConfiguredObjectRecord> records = new HashMap<UUID, ConfiguredObjectRecord>(this._records);
        for (DurableConfigurationStoreUpgrader upgrader : this.buildUpgraderList(version)) {
            for (ConfiguredObjectRecord record : records.values()) {
                upgrader.configuredObject(record);
            }
            upgrader.complete();
            Set<UUID> deleted = upgrader.getDeletedRecords().keySet();
            updatedRecords.putAll(upgrader.getUpdatedRecords());
            updatedRecords.keySet().removeAll(deleted);
            records.keySet().removeAll(deleted);
            records.putAll(updatedRecords);
        }
        HashMap<UUID, ConfiguredObjectRecord> deletedRecords = new HashMap<UUID, ConfiguredObjectRecord>(this._records);
        deletedRecords.keySet().removeAll(records.keySet());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this._rootCategory + " store upgrade is about to complete. " + this._records.size() + " total record(s). Records to update " + updatedRecords.size() + " Records to delete " + deletedRecords.size());
        }
        this._store.update(true, updatedRecords.values().toArray(new ConfiguredObjectRecord[updatedRecords.size()]));
        this._store.remove(deletedRecords.values().toArray(new ConfiguredObjectRecord[deletedRecords.size()]));
        this._records.keySet().removeAll(deletedRecords.keySet());
        this._records.putAll(updatedRecords);
    }

    private List<DurableConfigurationStoreUpgrader> buildUpgraderList(String version) {
        LinkedList<DurableConfigurationStoreUpgrader> result = new LinkedList<DurableConfigurationStoreUpgrader>();
        while (!"9.1".equals(version)) {
            StoreUpgraderPhase upgrader;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding " + this._rootCategory + " store upgrader from model version: " + version);
            }
            if ((upgrader = this._upgraders.get(version)) == null) {
                throw new IllegalConfigurationException("No phase upgrader for version " + version);
            }
            version = upgrader.getToVersion();
            result.add(upgrader);
        }
        return result;
    }

    private String getCurrentVersion() {
        for (ConfiguredObjectRecord record : this._records.values()) {
            if (!this._rootCategory.equals(record.getType())) continue;
            return (String)record.getAttributes().get(this._modelVersionAttributeName);
        }
        return "9.1";
    }
}

