/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.sasl.SaslNegotiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaslServerNegotiator
implements SaslNegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSaslServerNegotiator.class);

    @Override
    public void dispose() {
        SaslServer saslServer = this.getSaslServer();
        if (saslServer != null) {
            try {
                saslServer.dispose();
            }
            catch (SaslException e) {
                LOGGER.warn("Disposing of SaslServer failed", (Throwable)e);
            }
        }
    }

    @Override
    public AuthenticationResult handleResponse(byte[] response) {
        SaslServer saslServer = this.getSaslServer();
        if (saslServer == null) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, this.getSaslServerCreationException());
        }
        try {
            byte[] challenge = saslServer.evaluateResponse(response != null ? response : new byte[]{});
            if (saslServer.isComplete()) {
                String userId = saslServer.getAuthorizationID();
                return new AuthenticationResult(new UsernamePrincipal(userId, this.getAuthenticationProvider()), challenge);
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (IllegalStateException | SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    protected abstract Exception getSaslServerCreationException();

    protected abstract SaslServer getSaslServer();

    protected abstract AuthenticationProvider<?> getAuthenticationProvider();
}

