/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.AccessControlMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AccessControlProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AccessControl;
import org.apache.qpid.server.security.AllowAllAccessControlProvider;

public class AllowAllAccessControlProviderImpl
extends AbstractConfiguredObject<AllowAllAccessControlProviderImpl>
implements AllowAllAccessControlProvider<AllowAllAccessControlProviderImpl> {
    private final Broker _broker;
    @ManagedAttributeField
    private int _priority;

    @ManagedObjectFactoryConstructor
    public AllowAllAccessControlProviderImpl(Map<String, Object> attributes, Broker broker) {
        super(broker, attributes);
        this._broker = broker;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public AccessControl getController() {
        return AccessControl.ALWAYS_ALLOWED;
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(AccessControlMessages.OPERATION(operation));
    }

    private EventLogger getEventLogger() {
        return this._broker.getEventLogger();
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.QUIESCED, State.ERRORED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> activate() {
        this.setState(this._broker.isManagementMode() ? State.QUIESCED : State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    @StateTransition(currentState={State.UNINITIALIZED}, desiredState=State.QUIESCED)
    private CompletableFuture<Void> startQuiesced() {
        this.setState(State.QUIESCED);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int compareTo(AccessControlProvider<?> o) {
        return ACCESS_CONTROL_PROVIDER_COMPARATOR.compare(this, o);
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(AccessControlMessages.UPDATE(this.getName(), outcome.name(), this.attributesAsString(attributes)));
    }
}

