/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueStatistics;
import org.apache.qpid.server.store.MessageDurability;

abstract class AbstractQueueEntryList
implements QueueEntryList {
    private final boolean _forcePersistent;
    private final boolean _respectPersistent;
    private final Queue<?> _queue;
    private final QueueStatistics _queueStatistics;

    protected AbstractQueueEntryList(Queue<?> queue, QueueStatistics queueStatistics) {
        MessageDurability messageDurability = queue.getMessageDurability();
        this._queue = queue;
        this._queueStatistics = queueStatistics;
        this._forcePersistent = messageDurability == MessageDurability.ALWAYS;
        this._respectPersistent = messageDurability == MessageDurability.DEFAULT;
    }

    void updateStatsOnEnqueue(QueueEntry entry) {
        long sizeWithHeader = entry.getSizeWithHeader();
        QueueStatistics queueStatistics = this._queueStatistics;
        queueStatistics.addToAvailable(sizeWithHeader);
        queueStatistics.addToQueue(sizeWithHeader);
        queueStatistics.addToEnqueued(sizeWithHeader);
        if (this._forcePersistent || this._respectPersistent && entry.getMessage().isPersistent()) {
            queueStatistics.addToPersistentEnqueued(sizeWithHeader);
        }
    }

    @Override
    public void updateStatsOnStateChange(QueueEntry entry, MessageInstance.EntryState fromState, MessageInstance.EntryState toState) {
        QueueStatistics queueStatistics = this._queueStatistics;
        long sizeWithHeader = entry.getSizeWithHeader();
        boolean isConsumerAcquired = toState instanceof MessageInstance.ConsumerAcquiredState;
        boolean wasConsumerAcquired = fromState instanceof MessageInstance.ConsumerAcquiredState;
        switch (fromState.getState()) {
            case AVAILABLE: {
                queueStatistics.removeFromAvailable(sizeWithHeader);
                break;
            }
            case ACQUIRED: {
                if (!wasConsumerAcquired || isConsumerAcquired) break;
                queueStatistics.removeFromUnacknowledged(sizeWithHeader);
            }
        }
        switch (toState.getState()) {
            case AVAILABLE: {
                queueStatistics.addToAvailable(sizeWithHeader);
                this._queue.checkCapacity();
                break;
            }
            case ACQUIRED: {
                if (!isConsumerAcquired || wasConsumerAcquired) break;
                queueStatistics.addToUnacknowledged(sizeWithHeader);
                break;
            }
            case DELETED: {
                queueStatistics.removeFromQueue(sizeWithHeader);
                queueStatistics.addToDequeued(sizeWithHeader);
                if (this._forcePersistent || this._respectPersistent && entry.isPersistent()) {
                    queueStatistics.addToPersistentDequeued(sizeWithHeader);
                }
                this._queue.checkCapacity();
            }
        }
    }
}

