/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.util.HashMap;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessageMutator;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaData;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;

public class InternalMessageMutator
implements ServerMessageMutator<InternalMessage> {
    private final InternalMessage _message;
    private final MessageStore _messageStore;
    private byte _priority;

    InternalMessageMutator(InternalMessage message, MessageStore messageStore) {
        this._message = message;
        this._messageStore = messageStore;
        InternalMessageHeader messageHeader = this._message.getMessageHeader();
        this._priority = messageHeader.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this._priority = priority;
    }

    @Override
    public byte getPriority() {
        return this._priority;
    }

    @Override
    public InternalMessage create() {
        InternalMessageHeader messageHeader = this._message.getMessageHeader();
        InternalMessageHeader newHeader = new InternalMessageHeader(new HashMap<String, Object>(messageHeader.getHeaderMap()), messageHeader.getCorrelationId(), messageHeader.getExpiration(), messageHeader.getUserId(), messageHeader.getAppId(), messageHeader.getMessageId(), messageHeader.getMimeType(), messageHeader.getEncoding(), this._priority, messageHeader.getTimestamp(), messageHeader.getNotValidBefore(), messageHeader.getType(), messageHeader.getReplyTo(), this._message.getArrivalTime());
        long contentSize = this._message.getSize();
        InternalMessageMetaData metaData = InternalMessageMetaData.create(this._message.isPersistent(), newHeader, (int)contentSize);
        MessageHandle<InternalMessageMetaData> handle = this._messageStore.addMessage(metaData);
        QpidByteBuffer content = this._message.getContent();
        if (content != null) {
            handle.addContent(content);
        }
        StoredMessage<InternalMessageMetaData> storedMessage = handle.allContentAdded();
        return new InternalMessage(storedMessage, newHeader, this._message.getMessageBody(), this._message.getTo());
    }
}

