/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.List;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.ArrivalTimeFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.plugin.MessageFilterFactory;
import org.apache.qpid.server.plugin.PluggableService;

@PluggableService
public final class ArrivalTimeFilterFactory
implements MessageFilterFactory {
    @Override
    public MessageFilter newInstance(List<String> arguments) {
        if (arguments == null || arguments.size() != 1) {
            throw new IllegalArgumentException(String.format("Cannot create a %s filter from these arguments: %s", this.getType(), arguments));
        }
        String periodArgument = arguments.get(0);
        try {
            long periodInSeconds = Long.parseLong(periodArgument);
            return new ArrivalTimeFilter(System.currentTimeMillis() - periodInSeconds * 1000L, periodInSeconds == 0L);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot create a %s filter.  Period value '%s' does not contain a parsable long value", this.getType(), periodArgument), e);
        }
    }

    @Override
    public String getType() {
        return AMQPFilterTypes.REPLAY_PERIOD.toString();
    }
}

