/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.util.LinkedHashMap;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentConverterRegistry;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.model.DestinationAddress;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.AMQPInvalidClassException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.protocol.v0_8.transport.MessagePublishInfo;
import org.apache.qpid.server.store.StoredMessage;

@PluggableService
public class MessageConverter_Internal_to_v0_8
implements MessageConverter<InternalMessage, AMQMessage> {
    public Class<InternalMessage> getInputClass() {
        return InternalMessage.class;
    }

    public Class<AMQMessage> getOutputClass() {
        return AMQMessage.class;
    }

    public AMQMessage convert(InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        return new AMQMessage(this.convertToStoredMessage(serverMsg, addressSpace), null);
    }

    public void dispose(AMQMessage message) {
    }

    private StoredMessage<MessageMetaData> convertToStoredMessage(final InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        byte[] messageContent;
        Object messageBody = serverMsg.getMessageBody();
        ObjectToMimeContentConverter converter = MimeContentConverterRegistry.getBestFitObjectToMimeContentConverter((Object)messageBody);
        try {
            messageContent = converter == null ? new byte[]{} : converter.toMimeContent(messageBody);
        }
        catch (IllegalArgumentException e) {
            throw new MessageConversionException("Could not convert message from Internal to 0-8 because conversion of message content failed.", (Throwable)e);
        }
        String mimeType = converter == null ? null : converter.getMimeType();
        mimeType = this.improveMimeType(serverMsg, mimeType);
        final MessageMetaData messageMetaData_0_8 = this.convertMetaData(serverMsg, addressSpace, mimeType, messageContent.length);
        final int metadataSize = messageMetaData_0_8.getStorableSize();
        return new StoredMessage<MessageMetaData>(){

            public MessageMetaData getMetaData() {
                return messageMetaData_0_8;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public QpidByteBuffer getContent(int offset, int length) {
                return QpidByteBuffer.wrap((byte[])messageContent, (int)offset, (int)length);
            }

            public int getContentSize() {
                return messageContent.length;
            }

            public int getMetadataSize() {
                return metadataSize;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean isInContentInMemory() {
                return true;
            }

            public long getInMemorySize() {
                return this.getContentSize() + this.getMetadataSize();
            }

            public boolean flowToDisk() {
                return false;
            }

            public void reallocate() {
            }
        };
    }

    private String improveMimeType(InternalMessage serverMsg, String mimeType) {
        if (serverMsg.getMessageHeader() != null && serverMsg.getMessageHeader().getMimeType() != null) {
            if ("text/plain".equals(mimeType) && serverMsg.getMessageHeader().getMimeType().startsWith("text/")) {
                mimeType = serverMsg.getMessageHeader().getMimeType();
            } else if ("application/octet-stream".equals(mimeType)) {
                mimeType = serverMsg.getMessageHeader().getMimeType();
            }
        }
        return mimeType;
    }

    private MessageMetaData convertMetaData(InternalMessage serverMsg, NamedAddressSpace addressSpace, String bodyMimeType, int size) {
        MessagePublishInfo publishInfo = this.createMessagePublishInfo(serverMsg, addressSpace);
        BasicContentHeaderProperties props = new BasicContentHeaderProperties();
        props.setAppId(serverMsg.getMessageHeader().getAppId());
        props.setContentType(bodyMimeType);
        props.setCorrelationId(this.convertToShortStringForProperty("correlation-id", serverMsg.getMessageHeader().getCorrelationId()));
        props.setDeliveryMode(serverMsg.isPersistent() ? (byte)2 : 1);
        props.setExpiration(serverMsg.getExpiration());
        props.setMessageId(this.convertToOptionalAMQPShortString(serverMsg.getMessageHeader().getMessageId()));
        props.setPriority(serverMsg.getMessageHeader().getPriority());
        props.setReplyTo(this.convertToShortStringForProperty("reply-to", this.getReplyTo(serverMsg, addressSpace)));
        props.setTimestamp(serverMsg.getMessageHeader().getTimestamp());
        props.setUserId(this.convertToOptionalAMQPShortString(serverMsg.getMessageHeader().getUserId()));
        props.setEncoding(this.convertToShortStringForProperty("encoding", serverMsg.getMessageHeader().getEncoding()));
        LinkedHashMap<String, Object> headerProps = new LinkedHashMap<String, Object>();
        for (String headerName : serverMsg.getMessageHeader().getHeaderNames()) {
            headerProps.put(headerName, serverMsg.getMessageHeader().getHeader(headerName));
        }
        try {
            props.setHeaders(FieldTable.convertToFieldTable(headerProps));
        }
        catch (IllegalArgumentException | AMQPInvalidClassException e) {
            throw new MessageConversionException("Could not convert message from internal to 0-8 because headers conversion failed.", (Throwable)e);
        }
        ContentHeaderBody chb = new ContentHeaderBody(props);
        chb.setBodySize(size);
        return new MessageMetaData(publishInfo, chb, serverMsg.getArrivalTime());
    }

    private MessagePublishInfo createMessagePublishInfo(InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        String routingKey;
        String exchangeName;
        String to = serverMsg.getTo();
        if (to == null || "".equals(to)) {
            to = serverMsg.getInitialRoutingAddress();
        }
        if (to != null && !"".equals(to)) {
            DestinationAddress destinationAddress = new DestinationAddress(addressSpace, to);
            MessageDestination messageDestination = destinationAddress.getMessageDestination();
            if (messageDestination instanceof Queue) {
                exchangeName = "";
                routingKey = messageDestination.getName();
            } else if (messageDestination instanceof Exchange) {
                exchangeName = messageDestination.getName();
                routingKey = destinationAddress.getRoutingKey();
            } else {
                exchangeName = "";
                routingKey = to;
            }
        } else {
            exchangeName = "";
            routingKey = "";
        }
        return new MessagePublishInfo(this.convertToShortStringForProperty("to", exchangeName), false, false, this.convertToShortStringForProperty("to' or 'subject", routingKey));
    }

    private String getReplyTo(InternalMessage serverMsg, NamedAddressSpace addressSpace) {
        String replyTo = serverMsg.getMessageHeader().getReplyTo();
        if (replyTo != null) {
            String replyToBindingUrl;
            DestinationAddress destinationAddress = new DestinationAddress(addressSpace, replyTo);
            MessageDestination messageDestination = destinationAddress.getMessageDestination();
            if (messageDestination instanceof Exchange) {
                Exchange exchange = (Exchange)messageDestination;
                String routingKeyOption = "".equals(destinationAddress.getRoutingKey()) ? "" : String.format("?routingkey='%s'", destinationAddress.getRoutingKey());
                replyToBindingUrl = String.format("%s://%s//%s", exchange.getType(), exchange.getName(), routingKeyOption);
            } else {
                replyToBindingUrl = messageDestination instanceof Queue ? String.format("%s:////%s", "direct", messageDestination.getName()) : String.format("%s:////?routingkey='%s'", "direct", destinationAddress.getRoutingKey());
            }
            return replyToBindingUrl;
        }
        return null;
    }

    private AMQShortString convertToOptionalAMQPShortString(String stringValue) {
        AMQShortString result;
        try {
            result = AMQShortString.valueOf(stringValue);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    private AMQShortString convertToShortStringForProperty(String propertyName, String s) {
        try {
            return AMQShortString.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new MessageConversionException(String.format("Could not convert message from internal to 0-8 because conversion of '%s' failed.", propertyName), (Throwable)e);
        }
    }

    public String getType() {
        return "Internal to v0-8";
    }
}

