/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;

public class LongArrayStat
extends Stat<long[]> {
    private static final long serialVersionUID = 1L;
    protected long[] array;

    public LongArrayStat(StatGroup group, StatDefinition definition) {
        super(group, definition);
    }

    public LongArrayStat(StatGroup group, StatDefinition definition, long[] array) {
        super(group, definition);
        this.array = array;
    }

    @Override
    public long[] get() {
        return this.array;
    }

    @Override
    public void set(long[] array) {
        this.array = array;
    }

    @Override
    public void add(Stat<long[]> other) {
        throw EnvironmentFailureException.unexpectedState("LongArrayStat doesn't support the add operation.");
    }

    @Override
    public Stat<long[]> computeInterval(Stat<long[]> base) {
        return this.copy();
    }

    @Override
    public void negate() {
        throw EnvironmentFailureException.unexpectedState("LongArrayStat doesn't support the negate operation.");
    }

    @Override
    public void clear() {
        if (this.array != null && this.array.length > 0) {
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = 0L;
            }
        }
    }

    @Override
    public LongArrayStat copy() {
        try {
            LongArrayStat ret = (LongArrayStat)super.clone();
            if (this.array != null && this.array.length > 0) {
                long[] newArray = new long[this.array.length];
                System.arraycopy(this.array, 0, newArray, this.array.length - 1, this.array.length);
                ret.set(newArray);
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    @Override
    protected String getFormattedValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.array != null && this.array.length > 0) {
            boolean first = true;
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] <= 0L) continue;
                if (!first) {
                    sb.append("; ");
                }
                first = false;
                sb.append("level ").append(i).append(": count=");
                sb.append(Stat.FORMAT.format(this.array[i]));
            }
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isNotSet() {
        if (this.array == null) {
            return true;
        }
        return this.array.length == 0;
    }
}

