/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.net;

import com.sleepycat.je.rep.net.DataChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public interface DataChannelFactory {
    public DataChannel acceptChannel(SocketChannel var1);

    public DataChannel connect(InetSocketAddress var1, ConnectOptions var2) throws IOException;

    public static class ConnectOptions {
        private boolean tcpNoDelay = false;
        private int receiveBufferSize = 0;
        private int openTimeout = 0;
        private int readTimeout = 0;
        private boolean blocking = true;
        private boolean reuseAddr = false;

        public final ConnectOptions setTcpNoDelay(boolean tcpNoDelay) {
            this.tcpNoDelay = tcpNoDelay;
            return this;
        }

        public final boolean getTcpNoDelay() {
            return this.tcpNoDelay;
        }

        public final ConnectOptions setReceiveBufferSize(int rcvBufferSize) {
            this.receiveBufferSize = rcvBufferSize;
            return this;
        }

        public final int getReceiveBufferSize() {
            return this.receiveBufferSize;
        }

        public final ConnectOptions setOpenTimeout(int timeout) {
            this.openTimeout = timeout;
            return this;
        }

        public final int getOpenTimeout() {
            return this.openTimeout;
        }

        public final ConnectOptions setReadTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public final int getReadTimeout() {
            return this.readTimeout;
        }

        public final ConnectOptions setBlocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public final boolean getBlocking() {
            return this.blocking;
        }

        public final ConnectOptions setReuseAddr(boolean reuseAddr) {
            this.reuseAddr = reuseAddr;
            return this;
        }

        public final boolean getReuseAddr() {
            return this.reuseAddr;
        }

        public String toString() {
            return "ConnectOptions[tcpNoDelay = " + this.tcpNoDelay + ", receiveBufferSize = " + this.receiveBufferSize + ", openTimeout = " + this.openTimeout + ", readTimeout = " + this.readTimeout + ", blocking = " + this.blocking + ", reuseAddr = " + this.reuseAddr + "]";
        }
    }
}

