/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.latch.LatchTable;
import com.sleepycat.je.latch.OwnerInfo;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LatchSupport {
    public static final boolean TRACK_LATCHES = DatabaseUtil.TEST;
    static final boolean CAPTURE_OWNER = Boolean.getBoolean("JE_CAPTURE_LATCH_OWNER");
    static final boolean INTERRUPTIBLE_WITH_TIMEOUT = true;
    public static final LatchTable btreeLatchTable = TRACK_LATCHES ? new LatchTable() : null;
    public static final LatchTable otherLatchTable = TRACK_LATCHES ? new LatchTable() : null;
    public static final LatchContext DUMMY_LATCH_CONTEXT = new LatchContext(){

        @Override
        public int getLatchTimeoutMs() {
            return 0;
        }

        @Override
        public String getLatchName() {
            return null;
        }

        @Override
        public LatchTable getLatchTable() {
            return null;
        }

        @Override
        public EnvironmentImpl getEnvImplForFatalException() {
            return null;
        }
    };

    public static void expectBtreeLatchesHeld(int expectNLatches) {
        LatchSupport.expectBtreeLatchesHeld(expectNLatches, "");
    }

    public static void expectBtreeLatchesHeld(int expectNLatches, String msg) {
        int nHeld = btreeLatchTable.nLatchesHeld();
        if (nHeld == expectNLatches) {
            return;
        }
        throw EnvironmentFailureException.unexpectedState(String.format("Expected %d Btree latches held but got %d. %s\nLatch table: %s\n", expectNLatches, nHeld, msg, LatchSupport.btreeLatchesHeldToString()));
    }

    public static int nBtreeLatchesHeld() {
        return btreeLatchTable.nLatchesHeld();
    }

    public static void dumpBtreeLatchesHeld() {
        System.out.println(LatchSupport.btreeLatchesHeldToString());
    }

    public static String btreeLatchesHeldToString() {
        return btreeLatchTable.latchesHeldToString();
    }

    public static void clear() {
        if (TRACK_LATCHES) {
            btreeLatchTable.clear();
            otherLatchTable.clear();
        }
    }

    static void trackAcquire(Latch latch, LatchContext context) {
        LatchTable latchTable = context.getLatchTable();
        if (latchTable == null) {
            return;
        }
        if (!latchTable.add(latch)) {
            throw EnvironmentFailureException.unexpectedState("Latch already held." + latch.debugString());
        }
    }

    static void trackRelease(Latch latch, LatchContext context) {
        LatchTable latchTable = context.getLatchTable();
        if (latchTable == null) {
            return;
        }
        if (!latchTable.remove(latch)) {
            throw EnvironmentFailureException.unexpectedState("Latch not held." + latch.debugString());
        }
    }

    static String toString(Latch latch, LatchContext context, OwnerInfo lastOwnerInfo) {
        StringBuilder builder = new StringBuilder();
        builder.append(context.getLatchName()).append(" exclusiveOwner: ").append(latch.getExclusiveOwner());
        if (lastOwnerInfo != null) {
            lastOwnerInfo.toString(builder);
        }
        return builder.toString();
    }

    static String debugString(Latch latch, LatchContext context, OwnerInfo lastOwnerInfo) {
        LatchTable latchTable;
        StringBuilder builder = new StringBuilder(500);
        builder.append(context.getLatchName());
        builder.append(" currentThread: ");
        builder.append(Thread.currentThread());
        builder.append(" currentTime: ");
        builder.append(System.currentTimeMillis());
        if (TRACK_LATCHES && (latchTable = context.getLatchTable()) != null) {
            builder.append(" allLatchesHeld: (");
            builder.append(latchTable.latchesHeldToString());
            builder.append(")");
        }
        builder.append(" exclusiveOwner: ");
        Thread ownerThread = latch.getExclusiveOwner();
        if (ownerThread != null) {
            builder.append(ownerThread);
            if (lastOwnerInfo != null) {
                lastOwnerInfo.toString(builder);
            }
        } else {
            builder.append("-none-");
        }
        return builder.toString();
    }

    static EnvironmentFailureException handleTimeout(Latch latch, LatchContext context) {
        EnvironmentImpl envImpl = context.getEnvImplForFatalException();
        Logger logger = envImpl.getLogger();
        String msg = latch.debugString();
        LoggerUtils.logMsg(logger, envImpl, Level.SEVERE, "Thread dump follows for latch timeout: " + msg);
        LoggerUtils.fullThreadDump(logger, envImpl, Level.SEVERE);
        return EnvironmentFailureException.unexpectedState(envImpl, "Latch timeout. " + msg);
    }
}

