/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.hikaricp;

import com.zaxxer.hikari.HikariConfig;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;
import org.apache.qpid.server.store.jdbc.JDBCConnectionProviderFactory;
import org.apache.qpid.server.store.jdbc.hikaricp.HikariCPConnectionProvider;

@PluggableService
public class HikariCPConnectionProviderFactory
implements JDBCConnectionProviderFactory {
    static final String JDBC_STORE_PREFIX = "qpid.jdbcstore.";
    static final String HIKARICP_SETTING_PREFIX = "qpid.jdbcstore.hikaricp.";
    static final String MAXIMUM_POOLSIZE = "qpid.jdbcstore.hikaricp.maximumPoolSize";
    static final String MINIMUM_IDLE = "qpid.jdbcstore.hikaricp.minimumIdle";
    private final Set<String> _supportedAttributes = Arrays.stream(HikariConfig.class.getMethods()).filter(method -> this.isSetter((Method)method) && Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 1 && this.isPrimitiveOrString(method.getParameterTypes()[0])).map(method -> {
        Object name = method.getName().substring(3);
        name = HIKARICP_SETTING_PREFIX + Character.toLowerCase(((String)name).charAt(0)) + ((String)name).substring(1);
        return name;
    }).collect(Collectors.toUnmodifiableSet());

    public String getType() {
        return "HIKARICP";
    }

    public ConnectionProvider getConnectionProvider(String connectionUrl, String username, String password, KeyStore<?> keyStore, String keyStorePathPropertyName, String keyStorePasswordPropertyName, TrustStore<?> trustStore, String trustStorePathPropertyName, String trustStorePasswordPropertyName, Map<String, String> providerAttributes) {
        return new HikariCPConnectionProvider(connectionUrl, username, password, keyStore, keyStorePathPropertyName, keyStorePasswordPropertyName, trustStore, trustStorePathPropertyName, trustStorePasswordPropertyName, providerAttributes);
    }

    public Set<String> getProviderAttributeNames() {
        return this._supportedAttributes;
    }

    private boolean isSetter(Method method) {
        return method.getName().startsWith("set") && method.getName().length() > 3;
    }

    private boolean isPrimitiveOrString(Class<?> parameterType) {
        return parameterType.isPrimitive() || parameterType == String.class;
    }
}

