/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.qpid.server.query.engine.evaluator.QueryEvaluator;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.set.SetExpression;
import org.apache.qpid.server.query.engine.parsing.query.OrderItem;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.apache.qpid.server.query.engine.parsing.query.WithItem;

public class QueryExpression<T, R>
extends AbstractExpressionNode<T, R> {
    private List<WithItem<T, R>> _withItems = new ArrayList<WithItem<T, R>>();
    private SetExpression<T, R> _setExpression;
    private final List<OrderItem<T, R>> _orderItems = new ArrayList<OrderItem<T, R>>();
    private Integer _limit;
    private Integer _offset;

    @Override
    public R apply(T value) {
        if (!(value instanceof QueryEvaluator)) {
            throw QueryEvaluationException.of("QueryEvaluator instance not supplied", new Object[0]);
        }
        QueryEvaluator queryEvaluator = (QueryEvaluator)value;
        return (R)queryEvaluator.evaluate(this);
    }

    public List<String> getDomains() {
        LinkedList<String> domains = new LinkedList<String>();
        this.getDomains(this._setExpression, domains);
        return domains;
    }

    private void getDomains(ExpressionNode<T, ?> expression, List<String> domains) {
        if (expression instanceof SelectExpression) {
            SelectExpression select = (SelectExpression)expression;
            if (select.getFrom() != null) {
                domains.add(select.getFrom().getAlias());
            }
            if (select.getWhere() != null) {
                ((ExpressionNode)((Object)select.getWhere())).getChildren().forEach(child -> this.getDomains((ExpressionNode<T, ?>)child, domains));
            }
        } else {
            expression.getChildren().forEach(child -> this.getDomains((ExpressionNode<T, ?>)child, domains));
        }
    }

    public List<WithItem<T, R>> getWithItems() {
        return new ArrayList<WithItem<T, R>>(this._withItems);
    }

    public void setWithItems(List<WithItem<T, R>> withItems) {
        this._withItems = new ArrayList<WithItem<T, R>>(withItems);
    }

    public SetExpression<T, R> getSelect() {
        return this._setExpression;
    }

    public void setSelect(SetExpression<T, R> expression) {
        this._setExpression = expression;
    }

    public void addOrderItem(OrderItem<T, R> orderItem) {
        this._orderItems.add(orderItem);
    }

    public List<OrderItem<T, R>> getOrderItems() {
        return this._orderItems;
    }

    public Integer getLimit() {
        return this._limit;
    }

    public void setLimit(Integer limit) {
        this._limit = limit;
    }

    public Integer getOffset() {
        return this._offset;
    }

    public void setOffset(Integer offset) {
        this._offset = offset;
    }
}

