/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.report.ReportRunner;
import org.apache.qpid.server.management.plugin.servlet.rest.AbstractServlet;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.VirtualHost;

public class QueueReportServlet
extends AbstractServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response, ConfiguredObject<?> managedObject) throws IOException, ServletException {
        String reportName;
        Queue queue;
        List<String> pathInfoElements = HttpManagementUtil.getPathInfoElements(request.getServletPath(), request.getPathInfo());
        if (managedObject instanceof Broker && pathInfoElements.size() == 3) {
            queue = this.getQueueFromRequest(pathInfoElements);
            reportName = pathInfoElements.get(2);
        } else if (managedObject instanceof VirtualHost && pathInfoElements.size() == 2) {
            queue = this.getQueueFromVirtualHost(pathInfoElements.get(0), (VirtualHost)managedObject);
            reportName = pathInfoElements.get(1);
        } else {
            queue = null;
            reportName = null;
        }
        if (queue != null) {
            ReportRunner<?> reportRunner = ReportRunner.createRunner(reportName, request.getParameterMap());
            Object output = reportRunner.runReport(queue);
            response.setContentType(reportRunner.getContentType());
            if (reportRunner.isBinaryReport()) {
                response.getOutputStream().write((byte[])output);
            } else {
                response.getWriter().write((String)output);
            }
        } else {
            throw new IllegalArgumentException("Invalid path is specified");
        }
    }

    private Queue<?> getQueueFromRequest(List<String> pathInfoElements) {
        if (pathInfoElements.size() < 2) {
            throw new IllegalArgumentException("Invalid path is specified");
        }
        String vhostName = pathInfoElements.get(0);
        String queueName = pathInfoElements.get(1);
        VirtualHost vhost = this.getBroker().findVirtualHostByName(vhostName);
        if (vhost == null) {
            throw new IllegalArgumentException("Could not find virtual host with name '" + vhostName + "'");
        }
        Queue queueFromVirtualHost = this.getQueueFromVirtualHost(queueName, vhost);
        if (queueFromVirtualHost == null) {
            throw new IllegalArgumentException("Could not find queue with name '" + queueName + "' on virtual host '" + vhost.getName() + "'");
        }
        return queueFromVirtualHost;
    }

    private Queue getQueueFromVirtualHost(String queueName, VirtualHost<?> vhost) {
        Queue queue = null;
        for (Queue q : vhost.getChildren(Queue.class)) {
            if (!q.getName().equals(queueName)) continue;
            queue = q;
            break;
        }
        return queue;
    }
}

