/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.BindingController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.DestinationController;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.ConfiguredObject;

public class QueueController
extends DestinationController {
    public static final String TYPE = "Queue";

    QueueController(LegacyManagementController legacyManagementController, Set<TypeController> typeControllers) {
        super(legacyManagementController, TYPE, new String[]{"VirtualHost"}, "standard", typeControllers);
    }

    @Override
    protected LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject object) {
        return new LegacyQueue(this.getManagementController(), object);
    }

    @Override
    public Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        long queueFlowControlSizeBytesValue;
        LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(attributes);
        Object queueFlowControlSizeBytes = converted.remove("queueFlowControlSizeBytes");
        Object queueFlowResumeSizeBytes = converted.remove("queueFlowResumeSizeBytes");
        if (queueFlowControlSizeBytes != null && (queueFlowControlSizeBytesValue = ConverterHelper.toLong(queueFlowControlSizeBytes)) > 0L) {
            if (queueFlowResumeSizeBytes != null) {
                LinkedHashMap<String, String> contextMap;
                long queueFlowResumeSizeBytesValue = ConverterHelper.toLong(queueFlowResumeSizeBytes);
                double ratio = (double)queueFlowResumeSizeBytesValue / (double)queueFlowControlSizeBytesValue;
                String flowResumeLimit = String.format("%.2f", ratio * 100.0);
                Object context = converted.get("context");
                if (context instanceof Map) {
                    contextMap = (LinkedHashMap<String, String>)context;
                } else {
                    contextMap = new LinkedHashMap<String, String>();
                    converted.put("context", contextMap);
                }
                contextMap.put("queue.queueFlowResumeLimit", flowResumeLimit);
            }
            converted.put("overflowPolicy", "PRODUCER_FLOW_CONTROL");
            converted.put("maximumQueueDepthBytes", queueFlowControlSizeBytes);
        }
        if (converted.containsKey("messageGroupKey")) {
            if (converted.containsKey("messageGroupSharedGroups") && ConverterHelper.toBoolean(converted.remove("messageGroupSharedGroups"))) {
                converted.put("messageGroupType", "SHARED_GROUPS");
            } else {
                converted.put("messageGroupType", "STANDARD");
            }
            Object oldMessageGroupKey = converted.remove("messageGroupKey");
            if (!"JMSXGroupId".equals(oldMessageGroupKey)) {
                converted.put("messageGroupKeyOverride", oldMessageGroupKey);
            }
        } else {
            converted.put("messageGroupType", "NONE");
        }
        return super.convertAttributesToNextVersion(root, path, converted);
    }

    static class LegacyQueue
    extends DestinationController.LegacyDestination {
        static final String QUEUE_FLOW_RESUME_SIZE_BYTES = "queueFlowResumeSizeBytes";
        static final String QUEUE_FLOW_CONTROL_SIZE_BYTES = "queueFlowControlSizeBytes";
        static final String MESSAGE_GROUP_SHARED_GROUPS = "messageGroupSharedGroups";
        static final String MESSAGE_GROUP_KEY = "messageGroupKey";
        Set<String> MOVED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("queueFlowResumeSizeBytes", "queueFlowControlSizeBytes", "messageGroupSharedGroups", "messageGroupKey", "alternateExchange")));

        LegacyQueue(LegacyManagementController managementController, LegacyConfiguredObject nextVersionQueue) {
            super(managementController, nextVersionQueue, QueueController.TYPE);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return Stream.concat(super.getAttributeNames().stream(), this.MOVED_ATTRIBUTES.stream()).collect(Collectors.toSet());
        }

        @Override
        public Collection<LegacyConfiguredObject> getChildren(String category) {
            if ("Binding".equals(category)) {
                String queueName = (String)this.getAttribute("name");
                Collection<LegacyConfiguredObject> exchanges = this.getNextVersionLegacyConfiguredObject().getParent("VirtualHost").getChildren("Exchange");
                ArrayList<LegacyConfiguredObject> bindingObjects = new ArrayList<LegacyConfiguredObject>();
                for (LegacyConfiguredObject exchange : exchanges) {
                    Object bindings = exchange.getAttribute("bindings");
                    if (!(bindings instanceof Collection)) continue;
                    Collection exchangeBindings = (Collection)bindings;
                    exchangeBindings.stream().map(Binding.class::cast).filter(i -> i.getDestination().equals(queueName)).map(i -> new BindingController.LegacyBinding(this.getManagementController(), exchange, this.getNextVersionLegacyConfiguredObject(), i.getBindingKey(), i.getArguments())).forEach(bindingObjects::add);
                }
                return bindingObjects;
            }
            return super.getChildren(category);
        }

        @Override
        protected Object getAttributeInternal(String name, boolean isActual) {
            if (QUEUE_FLOW_CONTROL_SIZE_BYTES.equals(name)) {
                Object overflowPolicy = this.getAttribute("overflowPolicy", isActual);
                if (overflowPolicy != null) {
                    Object maximumQueueDepthBytes = this.getAttribute("maximumQueueDepthBytes", isActual);
                    if ("PRODUCER_FLOW_CONTROL".equals(String.valueOf(overflowPolicy)) && maximumQueueDepthBytes != null) {
                        return maximumQueueDepthBytes;
                    }
                }
                return null;
            }
            if (QUEUE_FLOW_RESUME_SIZE_BYTES.equals(name)) {
                long queueFlowControlSizeBytesValue;
                Object overflowPolicy = this.getAttribute("overflowPolicy", isActual);
                Object maximumQueueDepthBytes = this.getAttribute("maximumQueueDepthBytes", isActual);
                if ("PRODUCER_FLOW_CONTROL".equals(String.valueOf(overflowPolicy)) && maximumQueueDepthBytes != null && (queueFlowControlSizeBytesValue = ConverterHelper.toLong(maximumQueueDepthBytes)) > 0L) {
                    int queueFlowResumeLimit = 80;
                    Map context = (Map)super.getAttribute("context");
                    if (context != null && (queueFlowResumeLimit = ConverterHelper.toInt(context.get("queue.queueFlowResumeLimit"))) == 0) {
                        queueFlowResumeLimit = 80;
                    }
                    return Math.round((double)queueFlowControlSizeBytesValue * (double)queueFlowResumeLimit / 100.0);
                }
                return null;
            }
            if (MESSAGE_GROUP_SHARED_GROUPS.equals(name)) {
                Object messageGroupType = this.getAttribute("messageGroupType", isActual);
                if (messageGroupType != null) {
                    String type = String.valueOf(messageGroupType);
                    return "SHARED_GROUPS".equals(type);
                }
                return null;
            }
            if (MESSAGE_GROUP_KEY.equals(name)) {
                Object messageGroupKeyOverride = this.getAttribute("messageGroupKeyOverride", isActual);
                Object messageGroupType = this.getAttribute("messageGroupType", isActual);
                if (messageGroupType != null) {
                    return messageGroupKeyOverride == null ? "JMSXGroupId" : messageGroupKeyOverride;
                }
                return null;
            }
            return super.getAttributeInternal(name, isActual);
        }

        @Override
        public boolean isSecureAttribute(String name) {
            if (this.MOVED_ATTRIBUTES.contains(name)) {
                return false;
            }
            return super.isSecureAttribute(name);
        }

        @Override
        public boolean isOversizedAttribute(String name) {
            if (this.MOVED_ATTRIBUTES.contains(name)) {
                return false;
            }
            return super.isOversizedAttribute(name);
        }
    }
}

