/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.LegacyCategoryController;
import org.apache.qpid.server.model.ConfiguredObject;

public class PortController
extends LegacyCategoryController {
    public static final String TYPE = "Port";

    PortController(LegacyManagementController legacyManagementController, Set<TypeController> typeControllers) {
        super(legacyManagementController, TYPE, new String[]{"Broker"}, null, typeControllers);
    }

    @Override
    protected LegacyConfiguredObject convertNextVersionLegacyConfiguredObject(LegacyConfiguredObject object) {
        return new LegacyPort(this.getManagementController(), object);
    }

    @Override
    public Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        Map context;
        Map<String, Object> portAttributes = attributes;
        if ("HTTP".equals(portAttributes.get("type")) && portAttributes.containsKey("context") && ((context = (Map)portAttributes.get("context")).containsKey("port.http.additionalInternalThreads") || context.containsKey("port.http.maximumQueuedRequests"))) {
            LinkedHashMap<String, Object> updatedAttributes = new LinkedHashMap<String, Object>(portAttributes);
            updatedAttributes.put("context", this.convertContextToNextVersion(context));
            portAttributes = updatedAttributes;
        }
        return portAttributes;
    }

    private Map<String, String> convertContextToNextVersion(Map<String, String> context) throws ManagementException {
        if (context.containsKey("port.http.additionalInternalThreads") || context.containsKey("port.http.maximumQueuedRequests")) {
            LinkedHashMap<String, String> updatedContext = new LinkedHashMap<String, String>(context);
            updatedContext.remove("port.http.additionalInternalThreads");
            String acceptorsBacklog = (String)updatedContext.remove("port.http.maximumQueuedRequests");
            if (acceptorsBacklog != null) {
                updatedContext.put("qpid.port.http.acceptBacklog", acceptorsBacklog);
            }
            return updatedContext;
        }
        return context;
    }

    static class LegacyPort
    extends GenericLegacyConfiguredObject {
        LegacyPort(LegacyManagementController managementController, LegacyConfiguredObject nextVersionQueue) {
            super(managementController, nextVersionQueue, PortController.TYPE);
        }

        @Override
        public Object getAttribute(String name) {
            if ("context".equals(name) && "HTTP".equals(super.getAttribute("type"))) {
                Map context = (Map)super.getAttribute("context");
                return this.convertContextIfRequired(context);
            }
            return super.getAttribute(name);
        }

        @Override
        public Object getActualAttribute(String name) {
            if ("context".equals(name) && "HTTP".equals(super.getAttribute("type"))) {
                Map context = (Map)super.getActualAttribute("context");
                return this.convertContextIfRequired(context);
            }
            return super.getActualAttribute(name);
        }

        private Object convertContextIfRequired(Map<String, String> context) {
            if (context != null && context.containsKey("qpid.port.http.acceptBacklog")) {
                LinkedHashMap<String, String> updatedContext = new LinkedHashMap<String, String>(context);
                updatedContext.put("port.http.maximumQueuedRequests", (String)updatedContext.remove("qpid.port.http.acceptBacklog"));
                return updatedContext;
            }
            return context;
        }
    }
}

