/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.TenantDatabase;

public class DescribeTenantDatabasesIterable
implements SdkIterable<DescribeTenantDatabasesResponse> {
    private final RdsClient client;
    private final DescribeTenantDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTenantDatabasesIterable(RdsClient client, DescribeTenantDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTenantDatabasesResponseFetcher();
    }

    public Iterator<DescribeTenantDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TenantDatabase> tenantDatabases() {
        Function<DescribeTenantDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tenantDatabases() != null) {
                return response.tenantDatabases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTenantDatabasesResponseFetcher
    implements SyncPageFetcher<DescribeTenantDatabasesResponse> {
        private DescribeTenantDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTenantDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeTenantDatabasesResponse nextPage(DescribeTenantDatabasesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTenantDatabasesIterable.this.client.describeTenantDatabases(DescribeTenantDatabasesIterable.this.firstRequest);
            }
            return DescribeTenantDatabasesIterable.this.client.describeTenantDatabases((DescribeTenantDatabasesRequest)((Object)DescribeTenantDatabasesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

