/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.basicconfig.FibonacciBackoffConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class FibonacciBackoffConfigImpl
implements FibonacciBackoffConfig {
    private final String description;
    private final String configKey;
    private final FibonacciBackoff instance;
    private Long _maxDelay;
    private ChronoUnit _maxDelayUnit;

    private FibonacciBackoffConfigImpl(FaultToleranceMethod method) {
        boolean onMethod = method.annotationsPresentDirectly.contains(FibonacciBackoff.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.fibonacciBackoff;
    }

    private FibonacciBackoffConfigImpl(String id, FibonacciBackoff instance) {
        this.description = "Guard with @Identifier(" + id + ")";
        this.configKey = id;
        this.instance = instance;
    }

    public static FibonacciBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.fibonacciBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("fibonacci-backoff.enabled", "FibonacciBackoff/enabled", method.method)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(method);
    }

    public static FibonacciBackoffConfigImpl create(String id, Supplier<FibonacciBackoff> supplier) {
        if (supplier == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("fibonacci-backoff.enabled", "FibonacciBackoff/enabled", id)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(id, supplier.get());
    }

    public Class<? extends Annotation> annotationType() {
        return FibonacciBackoff.class;
    }

    public long maxDelay() {
        if (this._maxDelay == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fibonacci-backoff.max-delay";
            Object oldKey = this.configKey + "/FibonacciBackoff/maxDelay";
            this._maxDelay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> FibonacciBackoffConfigImpl.lambda$maxDelay$0(config, (String)oldKey)).orElse(null);
            if (this._maxDelay == null) {
                newKey = "smallrye.faulttolerance.global.fibonacci-backoff.max-delay";
                oldKey = "FibonacciBackoff/maxDelay";
                this._maxDelay = config.getOptionalValue((String)newKey, Long.TYPE).or(() -> FibonacciBackoffConfigImpl.lambda$maxDelay$1(config, (String)oldKey)).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = this.instance.maxDelay();
            }
        }
        return this._maxDelay;
    }

    public ChronoUnit maxDelayUnit() {
        if (this._maxDelayUnit == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fibonacci-backoff.max-delay-unit";
            Object oldKey = this.configKey + "/FibonacciBackoff/maxDelayUnit";
            this._maxDelayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> FibonacciBackoffConfigImpl.lambda$maxDelayUnit$2(config, (String)oldKey)).orElse(null);
            if (this._maxDelayUnit == null) {
                newKey = "smallrye.faulttolerance.global.fibonacci-backoff.max-delay-unit";
                oldKey = "FibonacciBackoff/maxDelayUnit";
                this._maxDelayUnit = config.getOptionalValue((String)newKey, ChronoUnit.class).or(() -> FibonacciBackoffConfigImpl.lambda$maxDelayUnit$3(config, (String)oldKey)).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = this.instance.maxDelayUnit();
            }
        }
        return this._maxDelayUnit;
    }

    public void materialize() {
        this.maxDelay();
        this.maxDelayUnit();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @FibonacciBackoff on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @FibonacciBackoff." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$maxDelayUnit$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$maxDelayUnit$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, ChronoUnit.class);
    }

    private static /* synthetic */ Optional lambda$maxDelay$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }

    private static /* synthetic */ Optional lambda$maxDelay$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Long.TYPE);
    }
}

