/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.Enablement;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.metrics.MicroProfileMetricsProvider;
import io.smallrye.faulttolerance.metrics.MicrometerProvider;
import io.smallrye.faulttolerance.metrics.OpenTelemetryProvider;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
@Alternative
@Priority(value=1)
public class CompoundMetricsProvider
implements MetricsProvider {
    private final boolean enabled;
    private final MetricsProvider[] providers;
    private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

    @Inject
    CompoundMetricsProvider(Instance<MetricsProvider> lookup, Enablement enablement, @ConfigProperty(name="smallrye.faulttolerance.mpmetrics.disabled", defaultValue="false") boolean mpMetricsDisabled, @ConfigProperty(name="smallrye.faulttolerance.opentelemetry.disabled", defaultValue="false") boolean openTelemetryDisabled, @ConfigProperty(name="smallrye.faulttolerance.micrometer.disabled", defaultValue="false") boolean micrometerDisabled) {
        ArrayList<MetricsProvider> providers = new ArrayList<MetricsProvider>();
        if (!mpMetricsDisabled) {
            try {
                providers.add((MetricsProvider)lookup.select(MicroProfileMetricsProvider.class, new Annotation[0]).get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!openTelemetryDisabled) {
            try {
                providers.add((MetricsProvider)lookup.select(OpenTelemetryProvider.class, new Annotation[0]).get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!micrometerDisabled) {
            try {
                providers.add((MetricsProvider)lookup.select(MicrometerProvider.class, new Annotation[0]).get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.enabled = providers.isEmpty() ? false : enablement.metrics();
        this.providers = providers.toArray(new MetricsProvider[0]);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricsRecorder create(MeteredOperation operation) {
        if (this.enabled) {
            return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> {
                if (this.providers.length == 1) {
                    return this.providers[0].create(operation);
                }
                MetricsRecorder[] recorders = new MetricsRecorder[this.providers.length];
                for (int i = 0; i < this.providers.length; ++i) {
                    recorders[i] = this.providers[i].create(operation);
                }
                return new CompoundMetricsRecorder(recorders);
            });
        }
        return MetricsRecorder.NOOP;
    }

    private static class CompoundMetricsRecorder
    implements MetricsRecorder {
        private final MetricsRecorder[] recorders;

        private CompoundMetricsRecorder(MetricsRecorder ... recorders) {
            this.recorders = recorders;
        }

        public void executionFinished(boolean succeeded, boolean fallbackDefined, boolean fallbackApplied) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.executionFinished(succeeded, fallbackDefined, fallbackApplied);
            }
        }

        public void retryAttempted() {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.retryAttempted();
            }
        }

        public void retryValueReturned(boolean retried) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.retryValueReturned(retried);
            }
        }

        public void retryExceptionNotRetryable(boolean retried) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.retryExceptionNotRetryable(retried);
            }
        }

        public void retryMaxRetriesReached(boolean retried) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.retryMaxRetriesReached(retried);
            }
        }

        public void retryMaxDurationReached(boolean retried) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.retryMaxDurationReached(retried);
            }
        }

        public void timeoutFinished(boolean timedOut, long time) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.timeoutFinished(timedOut, time);
            }
        }

        public void circuitBreakerFinished(CircuitBreakerEvents.Result result) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.circuitBreakerFinished(result);
            }
        }

        public void circuitBreakerMovedToOpen() {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.circuitBreakerMovedToOpen();
            }
        }

        public void registerCircuitBreakerIsClosed(BooleanSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerCircuitBreakerIsClosed(supplier);
            }
        }

        public void registerCircuitBreakerIsOpen(BooleanSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerCircuitBreakerIsOpen(supplier);
            }
        }

        public void registerCircuitBreakerIsHalfOpen(BooleanSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerCircuitBreakerIsHalfOpen(supplier);
            }
        }

        public void registerCircuitBreakerTimeSpentInClosed(LongSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerCircuitBreakerTimeSpentInClosed(supplier);
            }
        }

        public void registerCircuitBreakerTimeSpentInOpen(LongSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerCircuitBreakerTimeSpentInOpen(supplier);
            }
        }

        public void registerCircuitBreakerTimeSpentInHalfOpen(LongSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerCircuitBreakerTimeSpentInHalfOpen(supplier);
            }
        }

        public void bulkheadDecisionMade(boolean accepted) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.bulkheadDecisionMade(accepted);
            }
        }

        public void registerBulkheadExecutionsRunning(LongSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerBulkheadExecutionsRunning(supplier);
            }
        }

        public void registerBulkheadExecutionsWaiting(LongSupplier supplier) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.registerBulkheadExecutionsWaiting(supplier);
            }
        }

        public void updateBulkheadRunningDuration(long time) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.updateBulkheadRunningDuration(time);
            }
        }

        public void updateBulkheadWaitingDuration(long time) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.updateBulkheadWaitingDuration(time);
            }
        }

        public void rateLimitDecisionMade(boolean permitted) {
            for (MetricsRecorder recorder : this.recorders) {
                recorder.rateLimitDecisionMade(permitted);
            }
        }
    }
}

