/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum EdgeAlgorithm {
    SPHERICAL,
    VINCENTY,
    THOMAS,
    ANDOYER,
    KARNEY;


    public static EdgeAlgorithm fromName(String algorithmName) {
        Preconditions.checkNotNull((Object)algorithmName, (Object)"Invalid edge interpolation algorithm: null");
        try {
            return EdgeAlgorithm.valueOf(algorithmName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid edge interpolation algorithm: %s", algorithmName), e);
        }
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}

