/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;

public class FileSpecificationValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightDocument pdfDoc = ctx.getDocument();
        COSDocument cDoc = pdfDoc.getDocument();
        List<COSObject> lCOSObj = cDoc.getObjects();
        for (COSObject o : lCOSObj) {
            COSDictionary dic;
            String type;
            COSBase cBase = o.getObject();
            if (!(cBase instanceof COSDictionary) || !"Filespec".equals(type = (dic = (COSDictionary)cBase).getNameAsString(COSName.TYPE)) && !COSName.F.getName().equals(type)) continue;
            this.validateFileSpecification(ctx, dic);
        }
    }

    public List<ValidationResult.ValidationError> validateFileSpecification(PreflightContext ctx, COSDictionary fileSpec) {
        ArrayList<ValidationResult.ValidationError> result = new ArrayList<ValidationResult.ValidationError>(0);
        if (fileSpec.getItem(COSName.getPDFName("EF")) != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.2.9", "EmbeddedFile entry is present in a FileSpecification dictionary"));
        }
        return result;
    }
}

