/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jspecify.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractSmartHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class AbstractKotlinSerializationHttpMessageConverter<T extends SerialFormat>
extends AbstractSmartHttpMessageConverter<Object> {
    private final Map<KType, KSerializer<Object>> kTypeSerializerCache = new ConcurrentReferenceHashMap();
    private final Map<Type, KSerializer<Object>> typeSerializerCache = new ConcurrentReferenceHashMap();
    private final T format;
    private final Predicate<ResolvableType> typePredicate;

    protected AbstractKotlinSerializationHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.typePredicate = KotlinDetector::hasSerializableAnnotation;
        this.format = format;
    }

    protected AbstractKotlinSerializationHttpMessageConverter(T format, Predicate<ResolvableType> typePredicate, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.typePredicate = typePredicate;
        this.format = format;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        return this.getSupportedMediaTypes();
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        ResolvableType type = ResolvableType.forClass(clazz);
        if (!this.typePredicate.test(type)) {
            return false;
        }
        return this.serializer(type, null) != null;
    }

    @Override
    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        if (!this.typePredicate.test(type) || ResolvableType.NONE.equals((Object)type)) {
            return false;
        }
        return this.serializer(type, null) != null && this.canRead(mediaType);
    }

    @Override
    public boolean canWrite(ResolvableType type, Class<?> valueClass, @Nullable MediaType mediaType) {
        ResolvableType resolvableType;
        ResolvableType resolvableType2 = resolvableType = ResolvableType.NONE.equals((Object)type) ? ResolvableType.forClass(valueClass) : type;
        if (!this.typePredicate.test(resolvableType)) {
            return false;
        }
        return this.serializer(resolvableType, null) != null && this.canWrite(mediaType);
    }

    @Override
    public final Object read(ResolvableType type, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
        KSerializer<Object> serializer = this.serializer(type, hints);
        if (serializer == null) {
            throw new HttpMessageNotReadableException("Could not find KSerializer for " + String.valueOf(type), inputMessage);
        }
        return this.readInternal(serializer, this.format, inputMessage);
    }

    protected abstract Object readInternal(KSerializer<Object> var1, T var2, HttpInputMessage var3) throws IOException, HttpMessageNotReadableException;

    @Override
    protected final void writeInternal(Object object, ResolvableType type, HttpOutputMessage outputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        ResolvableType resolvableType = ResolvableType.NONE.equals((Object)type) ? ResolvableType.forInstance((Object)object) : type;
        KSerializer<Object> serializer = this.serializer(resolvableType, hints);
        if (serializer == null) {
            throw new HttpMessageNotWritableException("Could not find KSerializer for " + String.valueOf(resolvableType));
        }
        this.writeInternal(object, serializer, this.format, outputMessage);
    }

    protected abstract void writeInternal(Object var1, KSerializer<Object> var2, T var3, HttpOutputMessage var4) throws IOException, HttpMessageNotWritableException;

    private @Nullable KSerializer<Object> serializer(ResolvableType resolvableType, @Nullable Map<String, Object> hints) {
        if (hints != null && hints.containsKey(KType.class.getName())) {
            KType type = (KType)hints.get(KType.class.getName());
            KSerializer serializer = this.kTypeSerializerCache.get(type);
            if (serializer == null) {
                try {
                    serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (KType)type);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (serializer != null) {
                    this.kTypeSerializerCache.put(type, (KSerializer<Object>)serializer);
                }
            }
            return serializer;
        }
        Type type = resolvableType.getType();
        KSerializer serializer = this.typeSerializerCache.get(type);
        if (serializer == null) {
            try {
                serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (Type)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (serializer != null) {
                this.typeSerializerCache.put(type, (KSerializer<Object>)serializer);
            }
        }
        return serializer;
    }

    @Override
    protected boolean supportsRepeatableWrites(Object object) {
        return true;
    }
}

