/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.FileUtils;

public class VersionPrinter {
    @Generated
    private static final Log LOG = LogFactory.getLog(VersionPrinter.class);
    private static final String version = VersionPrinter.readVersion();
    private static final int majorVersion = VersionPrinter.parseVersion(0);
    private static final int minorVersion = VersionPrinter.parseVersion(1);

    private static int parseVersion(int index) {
        try {
            String[] parts = version.split("\\.");
            return Integer.parseInt(parts[index]);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse Flyway version", e);
        }
    }

    private static String readVersion() {
        try {
            return FileUtils.copyToString(VersionPrinter.class.getClassLoader().getResourceAsStream("org/flywaydb/core/internal/version.txt"), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to read Flyway version: " + e.getMessage(), e);
        }
    }

    @Generated
    private VersionPrinter() {
    }

    @Generated
    public static String getVersion() {
        return version;
    }

    @Generated
    public static int getMajorVersion() {
        return majorVersion;
    }

    @Generated
    public static int getMinorVersion() {
        return minorVersion;
    }
}

