/*
 * Decompiled with CFR 0.152.
 */
package okio;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.AsyncTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\bH\u0002J\u0015\u0010\u0012\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0082\nR\u0012\u0010\u0004\u001a\u00020\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00078\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0014"}, d2={"Lokio/PriorityQueue;", "", "<init>", "()V", "size", "", "array", "", "Lokio/AsyncTimeout;", "[Lokio/AsyncTimeout;", "first", "add", "", "node", "remove", "heapifyUp", "vacantIndex", "heapifyDown", "compareTo", "other", "okio"})
@SourceDebugExtension(value={"SMAP\nAsyncTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncTimeout.kt\nokio/PriorityQueue\n*L\n1#1,514:1\n509#1,3:515\n509#1,3:518\n509#1,3:521\n509#1,3:524\n*S KotlinDebug\n*F\n+ 1 AsyncTimeout.kt\nokio/PriorityQueue\n*L\n415#1:515,3\n448#1:518,3\n481#1:521,3\n491#1:524,3\n*E\n"})
public final class PriorityQueue {
    @JvmField
    public int size;
    @JvmField
    @NotNull
    public AsyncTimeout[] array = new AsyncTimeout[8];

    @Nullable
    public final AsyncTimeout first() {
        return this.array[1];
    }

    public final void add(@NotNull AsyncTimeout node) {
        int newSize;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.size = newSize = this.size + 1;
        if (newSize == this.array.length) {
            Object[] doubledArray = new AsyncTimeout[newSize * 2];
            ArraysKt.copyInto$default((Object[])this.array, (Object[])doubledArray, (int)0, (int)0, (int)0, (int)14, null);
            this.array = doubledArray;
        }
        this.heapifyUp(newSize, node);
    }

    /*
     * WARNING - void declaration
     */
    public final void remove(@NotNull AsyncTimeout node) {
        void $this$compareTo$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node.index != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int oldSize = this.size;
        int removedIndex = node.index;
        AsyncTimeout asyncTimeout = this.array[oldSize];
        Intrinsics.checkNotNull((Object)asyncTimeout);
        AsyncTimeout last = asyncTimeout;
        node.index = -1;
        this.array[oldSize] = null;
        this.size = oldSize - 1;
        if (node == last) {
            return;
        }
        PriorityQueue priorityQueue = this;
        AsyncTimeout asyncTimeout2 = node;
        AsyncTimeout other$iv = last;
        boolean $i$f$compareTo = false;
        long a$iv = $this$compareTo$iv.getTimeoutAt$okio();
        long b$iv = other$iv.getTimeoutAt$okio();
        int nodeCompareToLast = Intrinsics.compare((long)0L, (long)(b$iv - a$iv));
        if (nodeCompareToLast == 0) {
            this.array[removedIndex] = last;
            last.index = removedIndex;
        } else if (nodeCompareToLast < 0) {
            this.heapifyDown(removedIndex, last);
        } else {
            this.heapifyUp(removedIndex, last);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void heapifyUp(int vacantIndex, AsyncTimeout node) {
        int parentIndex;
        int vacantIndex2 = vacantIndex;
        while ((parentIndex = vacantIndex2 >> 1) != 0) {
            void $this$compareTo$iv;
            AsyncTimeout parentNode;
            Intrinsics.checkNotNull((Object)this.array[parentIndex]);
            PriorityQueue priorityQueue = this;
            AsyncTimeout asyncTimeout = parentNode;
            AsyncTimeout other$iv = node;
            boolean $i$f$compareTo = false;
            long a$iv = $this$compareTo$iv.getTimeoutAt$okio();
            long b$iv = other$iv.getTimeoutAt$okio();
            if (Intrinsics.compare((long)0L, (long)(b$iv - a$iv)) <= 0) break;
            parentNode.index = vacantIndex2;
            this.array[vacantIndex2] = parentNode;
            vacantIndex2 = parentIndex;
        }
        this.array[vacantIndex2] = node;
        node.index = vacantIndex2;
    }

    /*
     * WARNING - void declaration
     */
    private final void heapifyDown(int vacantIndex, AsyncTimeout node) {
        int vacantIndex2 = vacantIndex;
        while (true) {
            void $this$compareTo$iv;
            Object object;
            AsyncTimeout rightNode;
            Object leftNode;
            int leftIndex = vacantIndex2 << 1;
            int rightIndex = leftIndex + 1;
            if (rightIndex <= this.size) {
                void $this$compareTo$iv2;
                AsyncTimeout asyncTimeout = this.array[leftIndex];
                Intrinsics.checkNotNull((Object)asyncTimeout);
                leftNode = asyncTimeout;
                AsyncTimeout asyncTimeout2 = this.array[rightIndex];
                Intrinsics.checkNotNull((Object)asyncTimeout2);
                rightNode = asyncTimeout2;
                PriorityQueue priorityQueue = this;
                Object object2 = leftNode;
                AsyncTimeout other$iv = rightNode;
                boolean $i$f$compareTo = false;
                long a$iv = $this$compareTo$iv2.getTimeoutAt$okio();
                long b$iv = other$iv.getTimeoutAt$okio();
                object = Intrinsics.compare((long)0L, (long)(b$iv - a$iv)) < 0 ? leftNode : rightNode;
            } else {
                if (leftIndex > this.size) break;
                AsyncTimeout asyncTimeout = this.array[leftIndex];
                object = asyncTimeout;
                Intrinsics.checkNotNull((Object)asyncTimeout);
            }
            AsyncTimeout smallestChild = object;
            leftNode = this;
            rightNode = node;
            AsyncTimeout other$iv = smallestChild;
            boolean $i$f$compareTo = false;
            long a$iv = $this$compareTo$iv.getTimeoutAt$okio();
            long b$iv = other$iv.getTimeoutAt$okio();
            if (Intrinsics.compare((long)0L, (long)(b$iv - a$iv)) <= 0) break;
            int newVacantIndex = smallestChild.index;
            smallestChild.index = vacantIndex2;
            this.array[vacantIndex2] = smallestChild;
            vacantIndex2 = newVacantIndex;
        }
        this.array[vacantIndex2] = node;
        node.index = vacantIndex2;
    }

    private final int compareTo(AsyncTimeout $this$compareTo, AsyncTimeout other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        boolean $i$f$compareTo = false;
        long a = $this$compareTo.getTimeoutAt$okio();
        long b = other.getTimeoutAt$okio();
        return Intrinsics.compare((long)0L, (long)(b - a));
    }
}

