/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RingBuffer<T> {
    private final Object[] buffer;
    private int insertionPointer = 0;
    private boolean filled = false;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public RingBuffer(int size) {
        this.buffer = new Object[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T add(T value) {
        Objects.requireNonNull(value);
        this.writeLock.lock();
        try {
            Object removed = this.buffer[this.insertionPointer];
            this.buffer[this.insertionPointer] = value;
            if (this.insertionPointer == this.buffer.length - 1) {
                this.filled = true;
            }
            this.insertionPointer = (this.insertionPointer + 1) % this.buffer.length;
            Object object = removed;
            return (T)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getSize() {
        this.readLock.lock();
        try {
            int n = this.filled ? this.buffer.length : this.insertionPointer;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<T> getSelectedElements(Filter<T> filter) {
        return this.getSelectedElements(filter, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getSelectedElements(Filter<T> filter, int maxElements) {
        ArrayList<Object> selected = new ArrayList<Object>(1000);
        int numSelected = 0;
        this.readLock.lock();
        try {
            for (int i = 0; i < this.buffer.length && numSelected < maxElements; ++i) {
                Object element;
                int idx = (this.insertionPointer + i) % this.buffer.length;
                Object val = this.buffer[idx];
                if (val == null || !filter.select(element = val)) continue;
                selected.add(element);
                ++numSelected;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countSelectedElements(Filter<T> filter) {
        int numSelected = 0;
        this.readLock.lock();
        try {
            for (int i = 0; i < this.buffer.length; ++i) {
                Object element;
                int idx = (this.insertionPointer + i) % this.buffer.length;
                Object val = this.buffer[idx];
                if (val == null || !filter.select(element = val)) continue;
                ++numSelected;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return numSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeSelectedElements(Filter<T> filter) {
        int count = 0;
        this.writeLock.lock();
        try {
            for (int i = 0; i < this.buffer.length; ++i) {
                Object element;
                int idx = (this.insertionPointer + i + 1) % this.buffer.length;
                Object val = this.buffer[idx];
                if (val == null || !filter.select(element = val)) continue;
                this.buffer[idx] = null;
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return count;
    }

    public List<T> asList() {
        return this.getSelectedElements(value -> true);
    }

    public T getOldestElement() {
        this.readLock.lock();
        try {
            T t = this.getElementData(this.insertionPointer);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public T getNewestElement() {
        this.readLock.lock();
        try {
            int index = this.insertionPointer == 0 ? this.buffer.length - 1 : this.insertionPointer - 1;
            T t = this.getElementData(index);
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private T getElementData(int index) {
        this.readLock.lock();
        try {
            Object object = this.buffer[index];
            return (T)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void forEach(ForEachEvaluator<T> evaluator) {
        this.forEach(evaluator, IterationDirection.FORWARD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(ForEachEvaluator<T> evaluator, IterationDirection iterationDirection) {
        this.readLock.lock();
        try {
            int increment;
            int endIndex;
            int startIndex;
            if (iterationDirection == IterationDirection.FORWARD) {
                startIndex = 0;
                endIndex = this.buffer.length - 1;
                increment = 1;
            } else {
                startIndex = this.buffer.length - 1;
                endIndex = 0;
                increment = -1;
            }
            int i = startIndex;
            while (iterationDirection == IterationDirection.FORWARD ? i <= endIndex : i >= endIndex) {
                Object element;
                int idx = (this.insertionPointer + i) % this.buffer.length;
                Object val = this.buffer[idx];
                if (val != null && !evaluator.evaluate(element = val)) {
                    return;
                }
                i += increment;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static interface Filter<S> {
        public boolean select(S var1);
    }

    public static enum IterationDirection {
        FORWARD,
        BACKWARD;

    }

    public static interface ForEachEvaluator<S> {
        public boolean evaluate(S var1);
    }
}

