/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProcessGroupBox
implements Comparable<ProcessGroupBox> {
    public static final int PG_SIZE_WIDTH = 380;
    public static final int PG_SIZE_HEIGHT = 172;
    public static final int PG_SPACING = 50;
    private final int x;
    private final int y;
    public static final ProcessGroupBox CANVAS_CENTER = new ProcessGroupBox(0, 0);

    public ProcessGroupBox(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int distance() {
        return (int)Math.hypot(this.x, this.y);
    }

    public boolean intersects(ProcessGroupBox other) {
        if (this.x + 380 < other.x) {
            return false;
        }
        if (this.x > other.x + 380) {
            return false;
        }
        if (this.y + 172 < other.y) {
            return false;
        }
        return this.y <= other.y + 172;
    }

    public ProcessGroupBox findFreeSpace(List<ProcessGroupBox> allCoords) {
        List byClosest = allCoords.stream().sorted().collect(Collectors.toList());
        List freeSpots = byClosest.stream().filter(other -> byClosest.stream().noneMatch(other.right()::intersects)).map(ProcessGroupBox::right).collect(Collectors.toList());
        freeSpots.addAll(byClosest.stream().filter(other -> byClosest.stream().noneMatch(other.down()::intersects)).map(ProcessGroupBox::down).collect(Collectors.toList()));
        freeSpots.addAll(byClosest.stream().filter(other -> byClosest.stream().noneMatch(other.left()::intersects)).map(ProcessGroupBox::left).collect(Collectors.toList()));
        freeSpots.addAll(byClosest.stream().filter(other -> byClosest.stream().noneMatch(other.up()::intersects)).map(ProcessGroupBox::up).collect(Collectors.toList()));
        return freeSpots.stream().sorted().findFirst().orElse(CANVAS_CENTER);
    }

    public ProcessGroupBox right() {
        return new ProcessGroupBox(this.x + 380 + 50, this.y);
    }

    public ProcessGroupBox down() {
        return new ProcessGroupBox(this.x, this.y + 172 + 50);
    }

    public ProcessGroupBox up() {
        return new ProcessGroupBox(this.x, this.y - 50 - 172);
    }

    public ProcessGroupBox left() {
        return new ProcessGroupBox(this.x - 50 - 380, this.y);
    }

    @Override
    public int compareTo(ProcessGroupBox other) {
        return this.distance() - other.distance();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessGroupBox pgBox = (ProcessGroupBox)o;
        return Double.compare(pgBox.x, this.x) == 0 && Double.compare(pgBox.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

