/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class JdbcRule
implements TestRule {
    private final ConnectionSource connectionSource;
    private final String createTableStatement;
    private final String dropTableStatement;

    public JdbcRule(ConnectionSource connectionSource, String createTableStatement, String dropTableStatement) {
        this.connectionSource = Objects.requireNonNull(connectionSource, "connectionSource");
        this.createTableStatement = createTableStatement;
        this.dropTableStatement = dropTableStatement;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (Connection connection = JdbcRule.this.getConnection();
                     java.sql.Statement statement = connection.createStatement();){
                    try {
                        if (StringUtils.isNotEmpty((CharSequence)JdbcRule.this.createTableStatement)) {
                            statement.executeUpdate(JdbcRule.this.createTableStatement);
                        }
                        base.evaluate();
                    }
                    finally {
                        if (StringUtils.isNotEmpty((CharSequence)JdbcRule.this.dropTableStatement)) {
                            statement.executeUpdate(JdbcRule.this.dropTableStatement);
                        }
                        statement.execute("SHUTDOWN");
                    }
                }
            }
        };
    }

    public Connection getConnection() throws SQLException {
        return this.connectionSource.getConnection();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }
}

