/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.ShiroMessages;
import org.apache.knox.gateway.audit.api.AuditContext;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;
import org.apache.shiro.SecurityUtils;

public class ShiroSubjectIdentityAdapter
implements Filter {
    private static final ShiroMessages LOG = (ShiroMessages)MessagesFactory.get(ShiroMessages.class);
    private static final String SUBJECT_USER_GROUPS = "subject.userGroups";
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private static final String SHIRO_URL_CONFIG = "urls";
    private static Map<String, String> urls = new HashMap<String, String>();
    private static List<Matcher> anonUrls = new ArrayList<Matcher>();

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration params = filterConfig.getInitParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)param, (CharSequence)SHIRO_URL_CONFIG)) continue;
            String value = filterConfig.getInitParameter(param);
            String pathParam = param.substring(param.indexOf(46) + 1);
            urls.put(pathParam, value);
            if (!"anon".equalsIgnoreCase(value)) continue;
            Matcher urlMatcher = new Matcher();
            try {
                Template urlPatternTemplate = Parser.parseTemplate((String)pathParam);
                urlMatcher.add(urlPatternTemplate, (Object)pathParam);
                anonUrls.add(urlMatcher);
            }
            catch (URISyntaxException e) {
                LOG.invalidURLPattern(param);
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        org.apache.shiro.subject.Subject subject = SecurityUtils.getSubject();
        subject.hasRole("authenticatedUser");
        CallableChain callableChain = new CallableChain(request, response, chain);
        SecurityUtils.getSubject().execute((Callable)callableChain);
    }

    private static boolean isRequestPathInShiroConfig(HttpServletRequest request) throws URISyntaxException {
        boolean isPathInConfig = false;
        String requestContextPath = StringUtils.startsWith((CharSequence)request.getPathInfo(), (CharSequence)"/") ? request.getPathInfo() : "/" + request.getPathInfo();
        Template requestUrlTemplate = Parser.parseLiteral((String)requestContextPath);
        for (Matcher m : anonUrls) {
            if (m.match(requestUrlTemplate) == null) continue;
            isPathInConfig = true;
        }
        return isPathInConfig;
    }

    private static class CallableChain
    implements Callable<Void> {
        private FilterChain chain;
        ServletRequest request;
        ServletResponse response;

        CallableChain(ServletRequest request, ServletResponse response, FilterChain chain) {
            this.request = request;
            this.response = response;
            this.chain = chain;
        }

        @Override
        public Void call() throws Exception {
            PrivilegedExceptionAction<Void> action = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    chain.doFilter(request, response);
                    return null;
                }
            };
            org.apache.shiro.subject.Subject shiroSubject = SecurityUtils.getSubject();
            if (shiroSubject == null || shiroSubject.getPrincipal() == null) {
                if (!ShiroSubjectIdentityAdapter.isRequestPathInShiroConfig((HttpServletRequest)this.request)) {
                    throw new IllegalStateException("Unable to determine authenticated user from Shiro, please check that your Knox Shiro configuration is correct");
                }
                LOG.unauthenticatedPathBypass(((HttpServletRequest)this.request).getRequestURI());
                String principal = "anonymous";
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)new PrimaryPrincipal("anonymous"));
                AuditContext context = auditService.getContext();
                context.setUsername("anonymous");
                auditService.attachContext(context);
                Subject.doAs(subject, action);
            } else {
                HashSet<String> userGroups;
                String principal = shiroSubject.getPrincipal().toString();
                HashSet<Object> principals = new HashSet<Object>();
                PrimaryPrincipal p = new PrimaryPrincipal(principal);
                principals.add(p);
                AuditContext context = auditService.getContext();
                context.setUsername(principal);
                auditService.attachContext(context);
                String sourceUri = (String)this.request.getAttribute("sourceRequestContextUrl");
                auditor.audit("authentication", sourceUri, "uri", "success");
                if (SecurityUtils.getSubject().getSession().getAttribute((Object)ShiroSubjectIdentityAdapter.SUBJECT_USER_GROUPS) != null) {
                    userGroups = (HashSet<String>)SecurityUtils.getSubject().getSession().getAttribute((Object)ShiroSubjectIdentityAdapter.SUBJECT_USER_GROUPS);
                } else if (shiroSubject.getPrincipal() instanceof String) {
                    userGroups = new HashSet<String>(shiroSubject.getPrincipals().asSet());
                    userGroups.remove(principal);
                } else {
                    HashSet shiroPrincipals = new HashSet(shiroSubject.getPrincipals().asSet());
                    userGroups = new HashSet();
                    Iterator iterator = shiroPrincipals.iterator();
                    while (iterator.hasNext()) {
                        Principal shiroPrincipal = (Principal)iterator.next();
                        userGroups.add(shiroPrincipal.toString());
                    }
                }
                for (String userGroup : userGroups) {
                    GroupPrincipal gp = new GroupPrincipal(userGroup);
                    principals.add(gp);
                }
                auditor.audit("authentication", sourceUri, "uri", "success", "Groups: " + userGroups);
                Subject subject = new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
                Subject.doAs(subject, action);
            }
            return null;
        }
    }
}

