/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.hash;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.hash.AbstractByteHasher;
import jersey.repackaged.com.google.common.hash.AbstractStreamingHashFunction;
import jersey.repackaged.com.google.common.hash.HashCode;
import jersey.repackaged.com.google.common.hash.HashCodes;
import jersey.repackaged.com.google.common.hash.Hasher;

final class MessageDigestHashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final MessageDigest prototype;
    private final int bytes;
    private final boolean supportsClone;
    private final String toString;

    MessageDigestHashFunction(String algorithmName, String toString) {
        this.prototype = MessageDigestHashFunction.getMessageDigest(algorithmName);
        this.bytes = this.prototype.getDigestLength();
        this.toString = Preconditions.checkNotNull(toString);
        this.supportsClone = this.supportsClone();
    }

    private boolean supportsClone() {
        try {
            this.prototype.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    public String toString() {
        return this.toString;
    }

    private static MessageDigest getMessageDigest(String algorithmName) {
        try {
            return MessageDigest.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Hasher newHasher() {
        if (this.supportsClone) {
            try {
                return new MessageDigestHasher((MessageDigest)this.prototype.clone(), this.bytes);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.prototype.getAlgorithm()), this.bytes);
    }

    private static final class MessageDigestHasher
    extends AbstractByteHasher {
        private final MessageDigest digest;
        private final int bytes;
        private boolean done;

        private MessageDigestHasher(MessageDigest digest, int bytes) {
            this.digest = digest;
            this.bytes = bytes;
        }

        @Override
        protected void update(byte b) {
            this.checkNotDone();
            this.digest.update(b);
        }

        @Override
        protected void update(byte[] b, int off, int len) {
            this.checkNotDone();
            this.digest.update(b, off, len);
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot use Hasher after calling #hash() on it");
        }

        @Override
        public HashCode hash() {
            this.done = true;
            return this.bytes == this.digest.getDigestLength() ? HashCodes.fromBytesNoCopy(this.digest.digest()) : HashCodes.fromBytesNoCopy(Arrays.copyOf(this.digest.digest(), this.bytes));
        }
    }
}

