/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.io.AbstractStringValueTranscoder;

public class GeneralizedTimeValueTranscoder
extends AbstractStringValueTranscoder<Calendar> {
    private static final String YEAR_PATTERN = "(\\d{4})";
    private static final String MONTH_PATTERN = "((?:\\x30[\\x31-\\x39])|(?:\\x31[\\x30-\\x32]))";
    private static final String DAY_PATTERN = "((?:\\x30[\\x31-\\x39])|(?:[\\x31-\\x32][\\x30-\\x39])|(?:\\x33[\\x30-\\x31]))";
    private static final String HOUR_PATTERN = "((?:[\\x30-\\x31][\\x30-\\x39])|(?:\\x32[\\x30-\\x33]))";
    private static final String MIN_PATTERN = "([\\x30-\\x35][\\x30-\\x39])?";
    private static final String SECOND_PATTERN = "([\\x30-\\x35][\\x30-\\x39])?";
    private static final String FRACTION_PATTERN = "([,.](\\d+))?";
    private static final String TIMEZONE_PATTERN = "(Z|(?:[+-]((?:[\\x30-\\x31][\\x30-\\x39])|(?:\\x32[\\x30-\\x33]))([\\x30-\\x35][\\x30-\\x39])?))";
    private static final Pattern TIME_REGEX = Pattern.compile("(\\d{4})((?:\\x30[\\x31-\\x39])|(?:\\x31[\\x30-\\x32]))((?:\\x30[\\x31-\\x39])|(?:[\\x31-\\x32][\\x30-\\x39])|(?:\\x33[\\x30-\\x31]))((?:[\\x30-\\x31][\\x30-\\x39])|(?:\\x32[\\x30-\\x33]))([\\x30-\\x35][\\x30-\\x39])?([\\x30-\\x35][\\x30-\\x39])?([,.](\\d+))?(Z|(?:[+-]((?:[\\x30-\\x31][\\x30-\\x39])|(?:\\x32[\\x30-\\x33]))([\\x30-\\x35][\\x30-\\x39])?))");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            format.setTimeZone(UTC);
            return format;
        }
    };

    @Override
    public Calendar decodeStringValue(String value) {
        try {
            return this.parseGeneralizedTime(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String encodeStringValue(Calendar value) {
        DateFormat format = DATE_FORMAT.get();
        return format.format(value.getTime());
    }

    @Override
    public Class<Calendar> getType() {
        return Calendar.class;
    }

    protected Calendar parseGeneralizedTime(String value) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException("String to parse cannot be null.");
        }
        Matcher m = TIME_REGEX.matcher(value);
        if (!m.matches()) {
            throw new ParseException("Invalid generalized time string.", value.length());
        }
        String tzString = m.group(9);
        TimeZone tz = "Z".equals(tzString) ? UTC : TimeZone.getTimeZone("GMT" + tzString);
        Calendar calendar = Calendar.getInstance(tz, DEFAULT_LOCALE);
        calendar.setTimeInMillis(0L);
        calendar.setLenient(false);
        calendar.set(1, Integer.parseInt(m.group(1)));
        calendar.set(2, Integer.parseInt(m.group(2)) - 1);
        calendar.set(5, Integer.parseInt(m.group(3)));
        calendar.set(11, Integer.parseInt(m.group(4)));
        FractionalPart fraction = FractionalPart.Hours;
        int minutes = 0;
        if (m.group(5) != null) {
            fraction = FractionalPart.Minutes;
            minutes = Integer.parseInt(m.group(5));
        }
        calendar.set(12, minutes);
        int seconds = 0;
        if (m.group(6) != null) {
            fraction = FractionalPart.Seconds;
            seconds = Integer.parseInt(m.group(6));
        }
        calendar.set(13, seconds);
        calendar.add(14, 0);
        if (m.group(7) != null) {
            calendar.add(14, fraction.toMillis(m.group(8)));
        }
        calendar.getTimeInMillis();
        calendar.setLenient(true);
        return calendar;
    }

    private static enum FractionalPart {
        Hours(3600000),
        Minutes(60000),
        Seconds(1000);

        private final int scaleFactor;

        private FractionalPart(int scale) {
            this.scaleFactor = scale;
        }

        int toMillis(String fraction) {
            return (int)(Double.parseDouble('.' + fraction) * (double)this.scaleFactor);
        }
    }
}

