/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.channel.ChannelAsyncInputStream;
import org.apache.sshd.common.channel.ChannelAsyncOutputStream;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.LocalWindow;
import org.apache.sshd.common.channel.RemoteWindow;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AsyncCapableClientChannel
extends AbstractClientChannel {
    protected final boolean withErrorStream;
    protected CloseableExecutorService pumperService;
    protected Future<?> pumper;

    protected AsyncCapableClientChannel(String type, boolean withErrorStream) {
        super(type);
        this.withErrorStream = withErrorStream;
    }

    private <T> T unsupported(Supplier<? extends T> err) {
        if (!this.withErrorStream) {
            throw new UnsupportedOperationException(this.getChannelType() + " has no error stream");
        }
        return err.get();
    }

    @Override
    public OutputStream getErr() {
        return this.unsupported(() -> super.getErr());
    }

    @Override
    public IoInputStream getAsyncErr() {
        return this.unsupported(() -> super.getAsyncErr());
    }

    @Override
    public InputStream getInvertedErr() {
        return this.unsupported(() -> super.getInvertedErr());
    }

    @Override
    public void setErr(OutputStream err) {
        if (!this.withErrorStream) {
            throw new UnsupportedOperationException(this.getChannelType() + " does not support an error stream");
        }
        super.setErr(err);
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        if (!this.withErrorStream) {
            throw new UnsupportedOperationException(this.getChannelType() + " does not support extended data");
        }
        super.doWriteExtendedData(data, off, len);
    }

    @Override
    protected void doOpen() throws IOException {
        if (StreamingChannel.Streaming.Async.equals((Object)this.streaming)) {
            this.asyncIn = new ChannelAsyncOutputStream(this, 94){

                @Override
                protected CloseFuture doCloseGracefully() {
                    DefaultCloseFuture result = new DefaultCloseFuture(AsyncCapableClientChannel.this.getChannelId(), this.futureLock);
                    CloseFuture packetsWritten = super.doCloseGracefully();
                    packetsWritten.addListener(p -> {
                        try {
                            IoWriteFuture eofSent = AsyncCapableClientChannel.this.sendEof();
                            if (eofSent != null) {
                                eofSent.addListener(f -> result.setClosed());
                                return;
                            }
                        }
                        catch (Exception e) {
                            AsyncCapableClientChannel.this.getSession().exceptionCaught(e);
                        }
                        result.setClosed();
                    });
                    return result;
                }
            };
            this.asyncOut = new ChannelAsyncInputStream(this);
            if (this.withErrorStream) {
                this.asyncErr = this.redirectErrorStream ? this.asyncOut : new ChannelAsyncInputStream(this);
            }
        } else {
            ChannelPipedOutputStream pos;
            ChannelPipedInputStream pis;
            this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            LocalWindow wLocal = this.getLocalWindow();
            if (this.out == null) {
                pis = new ChannelPipedInputStream(this, wLocal);
                pos = new ChannelPipedOutputStream(pis);
                this.out = pos;
                this.invertedOut = pis;
            }
            if (this.err == null && this.withErrorStream) {
                if (this.redirectErrorStream) {
                    this.err = this.out;
                    this.invertedErr = this.invertedOut;
                } else {
                    pis = new ChannelPipedInputStream(this, wLocal);
                    pos = new ChannelPipedOutputStream(pis);
                    this.err = pos;
                    this.invertedErr = pis;
                }
            }
            if (this.in != null) {
                CloseableExecutorService service = this.getExecutorService();
                this.pumperService = service == null ? ThreadUtils.newSingleThreadExecutor("ClientInputStreamPump[" + Math.abs(System.nanoTime() & 0xFFFFL) + "]") : ThreadUtils.noClose(service);
                this.pumper = this.pumperService.submit(this::pumpInputStream);
            }
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), this::closeImmediately0).build();
    }

    protected void closeImmediately0() {
        if (this.pumper != null && this.pumperService != null && !this.pumperService.isShutdown()) {
            try {
                if (!this.pumper.isDone()) {
                    this.pumper.cancel(true);
                }
                this.pumperService.shutdownNow();
            }
            catch (Exception e) {
                this.warn("doCloseImmediately({}) failed {} to shutdown stream pumper: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            }
            finally {
                this.pumper = null;
                this.pumperService = null;
            }
        }
    }

    protected void pumpInputStream() {
        block6: {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                Session session = this.getSession();
                RemoteWindow wRemote = this.getRemoteWindow();
                long packetSize = wRemote.getPacketSize();
                ValidateUtils.checkTrue(packetSize > 0L && packetSize < Integer.MAX_VALUE, "Invalid remote packet size int boundary: %d", packetSize);
                byte[] buffer = new byte[(int)packetSize];
                int maxChunkSize = CoreModuleProperties.INPUT_STREAM_PUMP_CHUNK_SIZE.getRequired(session);
                maxChunkSize = Math.max(maxChunkSize, CoreModuleProperties.INPUT_STREAM_PUMP_CHUNK_SIZE.getRequiredDefault());
                while (!this.closeFuture.isClosed()) {
                    int len = this.securedRead(this.in, maxChunkSize, buffer, 0, buffer.length);
                    if (len < 0) {
                        if (debugEnabled) {
                            this.log.debug("pumpInputStream({}) EOF signalled", (Object)this);
                        }
                        this.sendEof();
                        return;
                    }
                    session.resetIdleTimeout();
                    if (len <= 0) continue;
                    this.invertedIn.write(buffer, 0, len);
                    this.invertedIn.flush();
                }
                if (debugEnabled) {
                    this.log.debug("pumpInputStream({}) close future closed", (Object)this);
                }
            }
            catch (Exception e) {
                if (this.isClosing()) break block6;
                this.error("pumpInputStream({}) Caught {} : {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
                this.close(false);
            }
        }
    }

    protected int securedRead(InputStream in, int maxChunkSize, byte[] buf, int off, int len) throws IOException {
        int availLen;
        int n = 0;
        do {
            int nread;
            if ((nread = in.read(buf, off + n, Math.min(maxChunkSize, len - n))) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((availLen = in.available()) > 0);
        return n;
    }
}

