/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;

public class RequestBeanPropertyMeta {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final Method getter;
    private final HttpPartType partType;
    private final Optional<HttpPartSerializer> serializer;
    private final HttpPartParser parser;
    private final HttpPartSchema schema;

    static Builder create(HttpPartType partType, Class<? extends Annotation> c, MethodInfo m) {
        HttpPartSchema.Builder sb = HttpPartSchema.create().name(m.getPropertyName());
        AnnotationProvider ap = AP;
        CollectionUtils.rstream(ap.find(Schema.class, m, new AnnotationTraversal[0])).forEach(x -> sb.apply((Annotation)x.inner()));
        CollectionUtils.rstream(ap.find(c, m, new AnnotationTraversal[0])).forEach(x -> sb.apply((Annotation)x.inner()));
        return new Builder().partType(partType).schema(sb.build()).getter(m.inner());
    }

    RequestBeanPropertyMeta(Builder b, HttpPartSerializer serializer, HttpPartParser parser) {
        this.partType = b.partType;
        this.schema = b.schema;
        this.getter = b.getter;
        this.serializer = Utils.opt(this.schema.getSerializer() == null ? serializer : BeanCreator.of(HttpPartSerializer.class).type(this.schema.getSerializer()).run());
        this.parser = this.schema.getParser() == null ? parser : BeanCreator.of(HttpPartParser.class).type(this.schema.getParser()).run();
    }

    public Method getGetter() {
        return this.getter;
    }

    public HttpPartParserSession getParser(HttpPartParserSession _default) {
        return this.parser == null ? _default : this.parser.getPartSession();
    }

    public String getPartName() {
        return this.schema == null ? null : this.schema.getName();
    }

    public HttpPartType getPartType() {
        return this.partType;
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public Optional<HttpPartSerializer> getSerializer() {
        return this.serializer;
    }

    static class Builder {
        HttpPartType partType;
        HttpPartSchema schema;
        Method getter;

        Builder() {
        }

        RequestBeanPropertyMeta build(HttpPartSerializer serializer, HttpPartParser parser) {
            return new RequestBeanPropertyMeta(this, serializer, parser);
        }

        Builder getter(Method value) {
            this.getter = value;
            return this;
        }

        Builder partType(HttpPartType value) {
            this.partType = value;
            return this;
        }

        Builder schema(HttpPartSchema value) {
            this.schema = value;
            return this;
        }
    }
}

