/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.Server;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Link
extends OpenApiElement {
    private String operationRef;
    private String operationId;
    private String description;
    private Object requestBody;
    private Server server;
    private Map<String, Object> parameters = CollectionUtils.map();

    public Link() {
    }

    public Link(Link copyFrom) {
        super(copyFrom);
        this.operationRef = copyFrom.operationRef;
        this.description = copyFrom.description;
        this.operationId = copyFrom.operationId;
        this.requestBody = copyFrom.requestBody;
        Server server = this.server = copyFrom.server == null ? null : copyFrom.server.copy();
        if (Utils.nn(copyFrom.parameters)) {
            this.parameters.putAll(copyFrom.parameters);
        }
    }

    public Link addParameter(String mimeType, Object parameter) {
        AssertionUtils.assertArgNotNull("mimeType", mimeType);
        AssertionUtils.assertArgNotNull("parameter", parameter);
        this.parameters.put(mimeType, parameter);
        return this;
    }

    public Link copy() {
        return new Link(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "operationRef" -> ConverterUtils.toType(this.getOperationRef(), type);
            case "operationId" -> ConverterUtils.toType(this.getOperationId(), type);
            case "requestBody" -> ConverterUtils.toType(this.getRequestBody(), type);
            case "parameters" -> ConverterUtils.toType(this.getParameters(), type);
            case "server" -> ConverterUtils.toType(this.getServer(), type);
            default -> super.get(property, type);
        };
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getOperationRef() {
        return this.operationRef;
    }

    public Map<String, Object> getParameters() {
        return Utils.nullIfEmpty(this.parameters);
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.operationId), "operationId").addIf(Utils.nn(this.operationRef), "operationRef").addIf(Utils.ne(this.parameters), "parameters").addIf(Utils.nn(this.requestBody), "requestBody").addIf(Utils.nn(this.server), "server").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Link set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> this.setDescription(Utils.s(value));
            case "operationId" -> this.setOperationId(Utils.s(value));
            case "operationRef" -> this.setOperationRef(Utils.s(value));
            case "parameters" -> this.setParameters(ConverterUtils.toMapBuilder(value, String.class, Object.class).sparse().build());
            case "requestBody" -> this.setRequestBody(value);
            case "server" -> this.setServer(ConverterUtils.toType(value, Server.class));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Link setDescription(String value) {
        this.description = value;
        return this;
    }

    public Link setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public Link setOperationRef(String value) {
        this.operationRef = value;
        return this;
    }

    public Link setParameters(Map<String, Object> value) {
        this.parameters.clear();
        if (Utils.nn(value)) {
            this.parameters.putAll(value);
        }
        return this;
    }

    public Link setRequestBody(Object val) {
        this.requestBody = val;
        return this;
    }

    public Link setServer(Server value) {
        this.server = value;
        return this;
    }

    @Override
    public Link strict() {
        super.strict();
        return this;
    }

    @Override
    public Link strict(Object value) {
        super.strict(value);
        return this;
    }
}

