/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class AssertionPredicate<T>
implements Predicate<T> {
    public static final Function<Object, String> VALUE = StringUtils::readable;
    private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, (String)"Messages");
    private static final String MSG_valueDidNotPassTest = MESSAGES.getString("valueDidNotPassTest");
    private static final String MSG_valueDidNotPassTestWithValue = MESSAGES.getString("valueDidNotPassTestWithValue");
    private final Predicate<T> inner;
    private final String message;
    private final Object[] args;
    final ThreadLocal<String> failedMessage = new ThreadLocal();

    public AssertionPredicate(Predicate<T> inner, String message, Object ... args) {
        this.inner = inner;
        if (Utils.nn((Object)message)) {
            this.message = message;
            this.args = args;
        } else if (inner instanceof AssertionPredicate) {
            this.message = MSG_valueDidNotPassTest;
            this.args = CollectionUtils.a((Object[])new Object[0]);
        } else {
            this.message = MSG_valueDidNotPassTestWithValue;
            this.args = CollectionUtils.a((Object[])new Function[]{VALUE});
        }
    }

    AssertionPredicate() {
        this.inner = null;
        this.message = null;
        this.args = null;
    }

    @Override
    public boolean test(T t) {
        this.failedMessage.remove();
        boolean b = this.inner.test(t);
        if (!b) {
            Object m = this.message;
            Object[] oargs = new Object[this.args.length];
            for (int i = 0; i < oargs.length; ++i) {
                Object a = this.args[i];
                if (a instanceof Function) {
                    Function a2 = (Function)a;
                    oargs[i] = Utils.r(a2.apply(t));
                    continue;
                }
                oargs[i] = Utils.r((Object)a);
            }
            m = Utils.f((String)m, (Object[])oargs);
            Predicate<T> predicate = this.inner;
            if (predicate instanceof AssertionPredicate) {
                AssertionPredicate inner2 = (AssertionPredicate)predicate;
                m = (String)m + "\n\t" + inner2.getFailureMessage();
            }
            this.failedMessage.set((String)m);
        }
        return this.inner.test(t);
    }

    protected String getFailureMessage() {
        return this.failedMessage.get();
    }

    public static class Or<T>
    extends AssertionPredicate<T> {
        private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, (String)"Messages");
        private static final String MSG_noPredicateTestsPassed = MESSAGES.getString("noPredicateTestsPassed");
        private final Predicate<T>[] inner;

        @SafeVarargs
        public Or(Predicate<T> ... inner) {
            this.inner = inner;
        }

        @Override
        public boolean test(T t) {
            this.failedMessage.remove();
            for (Predicate<T> p : this.inner) {
                if (!Utils.nn(p) || !p.test(t)) continue;
                return true;
            }
            String m = Utils.f((String)MSG_noPredicateTestsPassed, (Object[])new Object[0]);
            this.failedMessage.set(m);
            return false;
        }
    }

    public static class Not<T>
    extends AssertionPredicate<T> {
        private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, (String)"Messages");
        private static final String MSG_predicateTestsUnexpectedlyPassed = MESSAGES.getString("predicateTestsUnexpectedlyPassed");
        private final Predicate<T> inner;

        public Not(Predicate<T> inner) {
            this.inner = inner;
        }

        @Override
        public boolean test(T t) {
            boolean b;
            this.failedMessage.remove();
            Predicate<T> p = this.inner;
            if (Utils.nn(p) && (b = p.test(t))) {
                this.failedMessage.set(Utils.f((String)MSG_predicateTestsUnexpectedlyPassed, (Object[])new Object[0]));
                return false;
            }
            return true;
        }
    }

    public static class And<T>
    extends AssertionPredicate<T> {
        private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, (String)"Messages");
        private static final String MSG_predicateTestFailed = MESSAGES.getString("predicateTestFailed");
        private final Predicate<T>[] inner;

        @SafeVarargs
        public And(Predicate<T> ... inner) {
            this.inner = inner;
        }

        @Override
        public boolean test(T t) {
            this.failedMessage.remove();
            for (int i = 0; i < this.inner.length; ++i) {
                boolean b;
                Predicate<T> p = this.inner[i];
                if (!Utils.nn(p) || (b = p.test(t))) continue;
                Object m = Utils.f((String)MSG_predicateTestFailed, (Object[])new Object[]{i + 1});
                if (p instanceof AssertionPredicate) {
                    AssertionPredicate p2 = (AssertionPredicate)p;
                    m = (String)m + "\n\t" + p2.getFailureMessage();
                }
                this.failedMessage.set(m);
                return false;
            }
            return true;
        }
    }
}

