/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class FilteredSet<E>
extends AbstractSet<E> {
    private final Predicate<E> filter;
    private final Set<E> set;
    private final Class<E> elementType;
    private final Function<Object, E> elementFunction;

    public static <E> Builder<E> create(Class<E> elementType) {
        AssertionUtils.assertArgNotNull("elementType", elementType);
        Builder builder = new Builder();
        builder.elementType = elementType;
        return builder;
    }

    public static <E> Builder<E> create() {
        Builder builder = new Builder();
        builder.elementType = Object.class;
        return builder;
    }

    protected FilteredSet(Predicate<E> filter, Set<E> set, Class<E> elementType, Function<Object, E> elementFunction) {
        this.filter = AssertionUtils.assertArgNotNull("filter", filter);
        this.set = AssertionUtils.assertArgNotNull("set", set);
        this.elementType = AssertionUtils.assertArgNotNull("elementType", elementType);
        this.elementFunction = elementFunction;
    }

    @Override
    public boolean add(E e) {
        if (this.filter.test(e)) {
            return this.set.add(e);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.filter.test(e) || !this.set.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean wouldAccept(E element) {
        return this.filter.test(element);
    }

    public Predicate<E> getFilter() {
        return this.filter;
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    public boolean addConverted(Object element) {
        E convertedElement = this.convertElement(element);
        return this.add(convertedElement);
    }

    public FilteredSet<E> addAllConverted(Collection<?> source) {
        if (source != null) {
            for (Object e : source) {
                this.addConverted(e);
            }
        }
        return this;
    }

    public FilteredSet<E> addAny(Object ... values) {
        if (values != null) {
            for (Object o : values) {
                if (o == null) continue;
                if (o instanceof Collection) {
                    Collection c = (Collection)o;
                    this.addAllConverted(c);
                    continue;
                }
                if (o.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        this.addConverted(Array.get(o, i));
                    }
                    continue;
                }
                this.addConverted(o);
            }
        }
        return this;
    }

    private E convertElement(Object element) {
        if (this.elementFunction != null) {
            element = this.elementFunction.apply(element);
        }
        if (element == null) {
            if (this.elementType.isPrimitive()) {
                throw ThrowableUtils.rex("Cannot set null element for primitive type {0}", this.elementType.getName());
            }
            return null;
        }
        if (this.elementType.isInstance(element)) {
            return this.elementType.cast(element);
        }
        throw ThrowableUtils.rex("Object of type {0} could not be converted to element type {1}", Utils.cn(element), Utils.cn(this.elementType));
    }

    @Override
    public String toString() {
        return this.set.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    public static class Builder<E> {
        private Predicate<E> filter = v -> true;
        private Set<E> inner;
        private Class<E> elementType;
        private Function<Object, E> elementFunction;

        public Builder<E> filter(Predicate<E> value) {
            Predicate<E> newFilter = AssertionUtils.assertArgNotNull("value", value);
            this.filter = this.filter == null ? newFilter : this.filter.and(newFilter);
            return this;
        }

        public Builder<E> inner(Set<E> value) {
            this.inner = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder<E> elementFunction(Function<Object, E> value) {
            this.elementFunction = value;
            return this;
        }

        public FilteredSet<E> build() {
            LinkedHashSet set = this.inner != null ? this.inner : new LinkedHashSet();
            return new FilteredSet<E>(this.filter, set, this.elementType, this.elementFunction);
        }
    }
}

