/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import org.apache.juneau.UriResolver;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlUtils;

public class XmlWriter
extends SerializerWriter {
    private String defaultNsPrefix;
    private boolean enableNs;

    public XmlWriter(Writer out, boolean useWhitespace, int maxIndent, boolean trimStrings, char quoteChar, UriResolver uriResolver, boolean enableNs, Namespace defaultNamespace) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver);
        this.enableNs = enableNs;
        this.defaultNsPrefix = defaultNamespace == null ? null : defaultNamespace.name;
    }

    public XmlWriter(XmlWriter w) {
        super(w);
        this.enableNs = w.enableNs;
        this.defaultNsPrefix = w.defaultNsPrefix;
    }

    @Override
    public XmlWriter append(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException e) {
            throw new SerializeException(e);
        }
        return this;
    }

    @Override
    public XmlWriter append(char[] value) {
        super.append(value);
        return this;
    }

    @Override
    public XmlWriter append(int indent, char c) {
        super.append(indent, c);
        return this;
    }

    @Override
    public XmlWriter append(int indent, String text) {
        super.append(indent, text);
        return this;
    }

    @Override
    public XmlWriter append(Object text) {
        super.append(text);
        return this;
    }

    @Override
    public XmlWriter append(String text) {
        super.append(text);
        return this;
    }

    @Override
    public XmlWriter appendIf(boolean flag, char value) {
        super.appendIf(flag, value);
        return this;
    }

    @Override
    public XmlWriter appendIf(boolean flag, String value) {
        super.appendIf(flag, value);
        return this;
    }

    @Override
    public XmlWriter appendln(int indent, String text) {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public XmlWriter appendln(String text) {
        super.appendln(text);
        return this;
    }

    @Override
    public XmlWriter appendUri(Object value) {
        super.appendUri(value);
        return this;
    }

    public XmlWriter attr(Namespace ns, String name, Object value) {
        return this.oAttr(ns == null ? null : ns.name, name).q().attrValue(value, false).q();
    }

    public XmlWriter attr(String name, Object value) {
        return this.attr((String)null, name, value);
    }

    public XmlWriter attr(String name, Object value, boolean valNeedsEncoding) {
        return this.attr(null, name, value, valNeedsEncoding);
    }

    public XmlWriter attr(String ns, String name, Object value) {
        return this.oAttr(ns, name).q().attrValue(value, false).q();
    }

    public XmlWriter attr(String ns, String name, Object value, boolean valNeedsEncoding) {
        return this.oAttr(ns, name).q().attrValue(value, valNeedsEncoding).q();
    }

    public XmlWriter attrUri(Namespace ns, String name, Object value) {
        return this.attr(ns, name, (Object)this.uriResolver.resolve(value));
    }

    public XmlWriter attrUri(String name, Object value) {
        return this.attrUri((String)null, name, value);
    }

    public XmlWriter attrUri(String ns, String name, Object value) {
        return this.attr(ns, name, this.uriResolver.resolve(value), true);
    }

    public XmlWriter ceTag() {
        this.w('/').w('>');
        return this;
    }

    @Override
    public XmlWriter cr(int depth) {
        super.cr(depth);
        return this;
    }

    @Override
    public XmlWriter cre(int depth) {
        super.cre(depth);
        return this;
    }

    public XmlWriter cTag() {
        this.w('>');
        return this;
    }

    public XmlWriter eTag(int indent, String name) {
        return this.i(indent).eTag(name);
    }

    public XmlWriter eTag(int indent, String ns, String name) {
        return this.i(indent).eTag(ns, name, false);
    }

    public XmlWriter eTag(int indent, String ns, String name, boolean needsEncoding) {
        return this.i(indent).eTag(ns, name, needsEncoding);
    }

    public XmlWriter eTag(String name) {
        return this.eTag(null, name);
    }

    public XmlWriter eTag(String ns, String name) {
        return this.eTag(ns, name, false);
    }

    public XmlWriter eTag(String ns, String name, boolean needsEncoding) {
        this.w('<').w('/');
        if (this.enableNs && Utils.nn(ns) && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.w(ns).w(':');
        }
        if (needsEncoding) {
            XmlUtils.encodeElementName(this.out, name);
        } else {
            this.append(name);
        }
        this.w('>');
        return this;
    }

    @Override
    public XmlWriter i(int indent) {
        super.i(indent);
        return this;
    }

    @Override
    public XmlWriter ie(int indent) {
        super.ie(indent);
        return this;
    }

    @Override
    public XmlWriter nl(int indent) {
        super.nl(indent);
        return this;
    }

    @Override
    public XmlWriter nlIf(boolean flag, int indent) {
        super.nlIf(flag, indent);
        return this;
    }

    public XmlWriter oAttr(Namespace ns, String name) {
        return this.oAttr(ns == null ? null : ns.name, name);
    }

    public XmlWriter oAttr(String ns, String name) {
        this.w(' ');
        if (this.enableNs && Utils.nn(ns) && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.w(ns).w(':');
        }
        this.w(name).w('=');
        return this;
    }

    public XmlWriter oTag(int indent, String name) {
        return this.i(indent).oTag(null, name, false);
    }

    public XmlWriter oTag(int indent, String ns, String name) {
        return this.i(indent).oTag(ns, name, false);
    }

    public XmlWriter oTag(int indent, String ns, String name, boolean needsEncoding) {
        return this.i(indent).oTag(ns, name, needsEncoding);
    }

    public XmlWriter oTag(String name) {
        return this.oTag(null, name, false);
    }

    public XmlWriter oTag(String ns, String name) {
        return this.oTag(ns, name, false);
    }

    public XmlWriter oTag(String ns, String name, boolean needsEncoding) {
        this.w('<');
        if (this.enableNs && Utils.nn(ns) && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.w(ns).w(':');
        }
        if (needsEncoding) {
            XmlUtils.encodeElementName(this.out, name);
        } else {
            this.append(name);
        }
        return this;
    }

    @Override
    public XmlWriter q() {
        super.q();
        return this;
    }

    @Override
    public XmlWriter s() {
        super.s();
        return this;
    }

    @Override
    public XmlWriter sIf(boolean flag) {
        super.sIf(flag);
        return this;
    }

    public XmlWriter sTag(int indent, String name) {
        return this.i(indent).sTag(null, name, false);
    }

    public XmlWriter sTag(int indent, String ns, String name) {
        return this.i(indent).sTag(ns, name, false);
    }

    public XmlWriter sTag(int indent, String ns, String name, boolean needsEncoding) {
        return this.i(indent).sTag(ns, name, needsEncoding);
    }

    public XmlWriter sTag(String name) {
        return this.sTag(null, name);
    }

    public XmlWriter sTag(String ns, String name) {
        return this.sTag(ns, name, false);
    }

    public XmlWriter sTag(String ns, String name, boolean needsEncoding) {
        this.oTag(ns, name, needsEncoding).w('>');
        return this;
    }

    public XmlWriter tag(int indent, String name) {
        return this.i(indent).tag(name);
    }

    public XmlWriter tag(int indent, String ns, String name) {
        return this.i(indent).tag(ns, name);
    }

    public XmlWriter tag(int indent, String ns, String name, boolean needsEncoding) {
        return this.i(indent).tag(ns, name, needsEncoding);
    }

    public XmlWriter tag(String name) {
        return this.tag(null, name, false);
    }

    public XmlWriter tag(String ns, String name) {
        return this.tag(ns, name, false);
    }

    public XmlWriter tag(String ns, String name, boolean needsEncoding) {
        this.w('<');
        if (this.enableNs && Utils.nn(ns) && !ns.isEmpty() && !ns.equals(this.defaultNsPrefix)) {
            this.w(ns).w(':');
        }
        if (needsEncoding) {
            XmlUtils.encodeElementName(this.out, name);
        } else {
            this.w(name);
        }
        this.w('/').w('>');
        return this;
    }

    public XmlWriter text(Object value) {
        this.text(value, false);
        return this;
    }

    public XmlWriter text(Object value, boolean preserveWhitespace) {
        XmlUtils.encodeText(this, value, this.trimStrings, preserveWhitespace);
        return this;
    }

    public XmlWriter textUri(Object value) {
        this.text(this.uriResolver.resolve(value), false);
        return this;
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public XmlWriter w(char c) {
        super.w(c);
        return this;
    }

    @Override
    public XmlWriter w(String s) {
        super.w(s);
        return this;
    }

    private XmlWriter attrValue(Object value, boolean needsEncoding) {
        if (needsEncoding) {
            XmlUtils.encodeAttrValue(this.out, value, this.trimStrings);
        } else if (value instanceof URI || value instanceof URL) {
            this.append(this.uriResolver.resolve(value));
        } else {
            this.append(value);
        }
        return this;
    }
}

