/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import org.apache.juneau.commons.function.Consumer2;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

@FunctionalInterface
public interface ThrowingConsumer2<A, B>
extends Consumer2<A, B> {
    @Override
    default public void apply(A a, B b) {
        try {
            this.acceptThrows(a, b);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    @Override
    default public ThrowingConsumer2<A, B> andThen(ThrowingConsumer2<? super A, ? super B> after) {
        AssertionUtils.assertArgNotNull("after", after);
        return (a, b) -> {
            this.acceptThrows(a, b);
            after.acceptThrows(a, b);
        };
    }

    public void acceptThrows(A var1, B var2) throws Exception;
}

