/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.juneau.Enablement;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.ResourceSupplier;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.util.DefaultSettingsMap;
import org.apache.juneau.svl.VarResolver;

public class BasicDebugEnablement
extends DebugEnablement {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;

    public BasicDebugEnablement(BeanStore beanStore) {
        super(beanStore);
    }

    @Override
    protected DebugEnablement.Builder init(BeanStore beanStore) {
        DebugEnablement.Builder b = super.init(beanStore);
        DefaultSettingsMap defaultSettings = (DefaultSettingsMap)beanStore.getBean(DefaultSettingsMap.class).get();
        RestContext.Builder builder = (RestContext.Builder)((Object)beanStore.getBean(RestContext.Builder.class).get());
        ResourceSupplier resource = (ResourceSupplier)beanStore.getBean(ResourceSupplier.class).get();
        VarResolver varResolver = (VarResolver)beanStore.getBean(VarResolver.class).get();
        AnnotationProvider ap = AP;
        Enablement debugDefault = defaultSettings.get(Enablement.class, "RestContext.debugDefault").orElse(builder.isDebug() ? Enablement.ALWAYS : Enablement.NEVER);
        b.defaultEnable(debugDefault);
        ClassInfo ci = ClassInfo.ofProxy((Object)resource.get());
        CollectionUtils.rstream((List)ap.find(Rest.class, ci, new AnnotationTraversal[0])).map(AnnotationInfo::inner).forEach(x -> {
            String x2 = varResolver.resolve(x.debug());
            if (!x2.isEmpty()) {
                b.enable(Enablement.fromString((String)x2), ci.getNameFull());
            }
        });
        ci.getPublicMethods().stream().forEach(x -> CollectionUtils.rstream((List)ap.find(x, new AnnotationTraversal[0])).filter(RestOpAnnotation.REST_OP_GROUP).flatMap(ai -> ai.getValue(String.class, "debug").stream()).filter(Utils::ne).map(arg_0 -> ((VarResolver)varResolver).resolve(arg_0)).map(Enablement::fromString).filter(Objects::nonNull).forEach(e -> b.enable((Enablement)e, x.getFullName())));
        CollectionUtils.rstream((List)ap.find(Rest.class, ci, new AnnotationTraversal[0])).map(AnnotationInfo::inner).forEach(x -> {
            String x2 = varResolver.resolve(x.debugOn());
            for (Map.Entry e : StringUtils.splitMap((String)x2, (boolean)true).entrySet()) {
                String k = (String)e.getKey();
                String v = (String)e.getValue();
                if (v.isEmpty()) {
                    v = "ALWAYS";
                }
                if (k.isEmpty()) continue;
                Utils.opt((Object)Enablement.fromString((String)v)).ifPresent(en -> b.enable((Enablement)en, k));
            }
        });
        return b;
    }
}

