/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.client;

import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.loadbalance.RoundRobinConnectionLoadBalancingPolicy;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.uri.ServerLocatorParser;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;

public final class ActiveMQClient {
    private static int globalThreadPoolSize;
    private static int globalScheduledThreadPoolSize;
    private static int globalFlowControlThreadPoolSize;
    public static final String DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME;
    public static final long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD;
    public static final long DEFAULT_CLIENT_FAILURE_CHECK_PERIOD_INVM = -1L;
    public static final long DEFAULT_CONNECTION_TTL;
    public static final long DEFAULT_CONNECTION_TTL_INVM = -1L;
    public static final int DEFAULT_MIN_LARGE_MESSAGE_SIZE = 102400;
    public static final boolean DEFAULT_COMPRESS_LARGE_MESSAGES = false;
    public static final int DEFAULT_COMPRESSION_LEVEL = -1;
    public static final int DEFAULT_CONSUMER_WINDOW_SIZE = 0x100000;
    public static final int DEFAULT_CONSUMER_MAX_RATE = -1;
    public static final int DEFAULT_CONFIRMATION_WINDOW_SIZE = -1;
    public static final int DEFAULT_PRODUCER_WINDOW_SIZE = 65536;
    public static final int DEFAULT_PRODUCER_MAX_RATE = -1;
    public static final boolean DEFAULT_BLOCK_ON_ACKNOWLEDGE = false;
    public static final boolean DEFAULT_BLOCK_ON_DURABLE_SEND = true;
    public static final boolean DEFAULT_BLOCK_ON_NON_DURABLE_SEND = false;
    public static final boolean DEFAULT_AUTO_GROUP = false;
    public static final long DEFAULT_CALL_TIMEOUT = 30000L;
    public static final long DEFAULT_CALL_FAILOVER_TIMEOUT = 30000L;
    public static final int DEFAULT_ACK_BATCH_SIZE = 0x100000;
    public static final boolean DEFAULT_PRE_ACKNOWLEDGE = false;
    public static final boolean DEFAULT_ENABLED_SHARED_CLIENT_ID = false;
    public static final long DEFAULT_DISCOVERY_INITIAL_WAIT_TIMEOUT = 10000L;
    public static final long DEFAULT_DISCOVERY_REFRESH_TIMEOUT = 10000L;
    public static final int DEFAULT_DISCOVERY_PORT = 9876;
    public static final long DEFAULT_RETRY_INTERVAL = 2000L;
    public static final double DEFAULT_RETRY_INTERVAL_MULTIPLIER;
    public static final long DEFAULT_MAX_RETRY_INTERVAL;
    public static final int DEFAULT_RECONNECT_ATTEMPTS = 0;
    public static final int INITIAL_CONNECT_ATTEMPTS = 1;
    public static final int DEFAULT_FAILOVER_ATTEMPTS = 0;
    @Deprecated
    public static final boolean DEFAULT_FAILOVER_ON_INITIAL_CONNECTION = false;
    public static final boolean DEFAULT_IS_HA = false;
    public static final boolean DEFAULT_USE_GLOBAL_POOLS = true;
    public static final int DEFAULT_THREAD_POOL_MAX_SIZE = -1;
    public static final int DEFAULT_GLOBAL_THREAD_POOL_MAX_SIZE;
    public static final int DEFAULT_SCHEDULED_THREAD_POOL_MAX_SIZE = 5;
    public static final int DEFAULT_FLOW_CONTROL_THREAD_POOL_MAX_SIZE = 10;
    public static final boolean DEFAULT_CACHE_LARGE_MESSAGE_CLIENT = false;
    public static final int DEFAULT_INITIAL_MESSAGE_PACKET_SIZE = 1500;
    public static final int DEFAULT_ONMESSAGE_CLOSE_TIMEOUT = 10000;
    public static final boolean DEFAULT_XA = false;
    public static final boolean DEFAULT_HA = false;
    public static final String DEFAULT_CORE_PROTOCOL = "CORE";
    public static final boolean DEFAULT_USE_TOPOLOGY_FOR_LOADBALANCING = true;
    public static final String THREAD_POOL_MAX_SIZE_PROPERTY_KEY = "activemq.artemis.client.global.thread.pool.max.size";
    public static final String SCHEDULED_THREAD_POOL_SIZE_PROPERTY_KEY = "activemq.artemis.client.global.scheduled.thread.pool.core.size";
    public static final String FLOW_CONTROL_THREAD_POOL_SIZE_PROPERTY_KEY = "activemq.artemis.client.global.flowcontrol.thread.pool.core.size";
    private static ExecutorService globalThreadPool;
    private static ExecutorService globalFlowControlThreadPool;
    private static boolean injectedPools;
    private static ScheduledExecutorService globalScheduledThreadPool;

    public static synchronized void clearThreadPools() {
        ActiveMQClient.clearThreadPools(10L, TimeUnit.SECONDS);
    }

    public static synchronized void clearThreadPools(long time, TimeUnit unit) {
        if (injectedPools) {
            globalThreadPool = null;
            globalScheduledThreadPool = null;
            globalFlowControlThreadPool = null;
            injectedPools = false;
            return;
        }
        if (globalThreadPool != null) {
            globalThreadPool.shutdownNow();
            try {
                if (!globalThreadPool.awaitTermination(time, unit)) {
                    globalThreadPool.shutdownNow();
                    ActiveMQClientLogger.LOGGER.unableToProcessGlobalThreadPoolIn10Sec();
                }
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
            finally {
                globalThreadPool = null;
            }
        }
        if (globalScheduledThreadPool != null) {
            globalScheduledThreadPool.shutdownNow();
            try {
                if (!globalScheduledThreadPool.awaitTermination(time, unit)) {
                    globalScheduledThreadPool.shutdownNow();
                    ActiveMQClientLogger.LOGGER.unableToProcessScheduledlIn10Sec();
                }
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
            finally {
                globalScheduledThreadPool = null;
            }
        }
        if (globalFlowControlThreadPool != null) {
            globalFlowControlThreadPool.shutdownNow();
            try {
                if (!globalFlowControlThreadPool.awaitTermination(time, unit)) {
                    globalFlowControlThreadPool.shutdownNow();
                    ActiveMQClientLogger.LOGGER.unableToProcessGlobalFlowControlThreadPoolIn10Sec();
                }
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
            finally {
                globalFlowControlThreadPool = null;
            }
        }
    }

    public static synchronized void injectPools(ExecutorService globalThreadPool, ScheduledExecutorService scheduledThreadPool, ExecutorService flowControlThreadPool) {
        if (globalThreadPool == null || scheduledThreadPool == null || flowControlThreadPool == null) {
            throw new IllegalArgumentException("thread pools must not be null");
        }
        ActiveMQClient.clearThreadPools();
        ActiveMQClient.globalThreadPool = globalThreadPool;
        globalScheduledThreadPool = scheduledThreadPool;
        globalFlowControlThreadPool = flowControlThreadPool;
        injectedPools = true;
    }

    public static synchronized ExecutorService getGlobalThreadPool() {
        globalThreadPool = ActiveMQClient.internalGetGlobalThreadPool(globalThreadPool, "ActiveMQ-client-global-threads", globalThreadPoolSize);
        return globalThreadPool;
    }

    public static synchronized ExecutorService getGlobalFlowControlThreadPool() {
        globalFlowControlThreadPool = ActiveMQClient.internalGetGlobalThreadPool(globalFlowControlThreadPool, "ActiveMQ-client-global-flow-control-threads", globalFlowControlThreadPoolSize);
        return globalFlowControlThreadPool;
    }

    private static synchronized ExecutorService internalGetGlobalThreadPool(ExecutorService executorService, String groupName, int poolSize) {
        if (executorService == null) {
            ThreadFactory factory = AccessController.doPrivileged(() -> new ActiveMQThreadFactory(groupName, true, ClientSessionFactoryImpl.class.getClassLoader()));
            executorService = poolSize == -1 ? new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), factory) : new ActiveMQThreadPoolExecutor(0, poolSize, 60L, TimeUnit.SECONDS, factory);
        }
        return executorService;
    }

    public static synchronized ScheduledExecutorService getGlobalScheduledThreadPool() {
        if (globalScheduledThreadPool == null) {
            ThreadFactory factory = AccessController.doPrivileged(() -> new ActiveMQThreadFactory("ActiveMQ-client-global-scheduled-threads", true, ClientSessionFactoryImpl.class.getClassLoader()));
            globalScheduledThreadPool = new ScheduledThreadPoolExecutor(globalScheduledThreadPoolSize, factory);
        }
        return globalScheduledThreadPool;
    }

    public static int getGlobalThreadPoolSize() {
        return globalThreadPoolSize;
    }

    public static int getGlobalScheduledThreadPoolSize() {
        return globalScheduledThreadPoolSize;
    }

    public static int getGlobalFlowControlThreadPoolSize() {
        return globalFlowControlThreadPoolSize;
    }

    public static void initializeGlobalThreadPoolProperties() {
        ActiveMQClient.setGlobalThreadPoolProperties(Integer.parseInt(System.getProperty(THREAD_POOL_MAX_SIZE_PROPERTY_KEY, "" + DEFAULT_GLOBAL_THREAD_POOL_MAX_SIZE)), Integer.parseInt(System.getProperty(SCHEDULED_THREAD_POOL_SIZE_PROPERTY_KEY, "5")), Integer.parseInt(System.getProperty(FLOW_CONTROL_THREAD_POOL_SIZE_PROPERTY_KEY, "10")));
    }

    public static void setGlobalThreadPoolProperties(int globalThreadMaxPoolSize, int globalScheduledThreadPoolSize, int globalFlowControlThreadPoolSize) {
        if (globalThreadMaxPoolSize < 2 && globalThreadMaxPoolSize != -1) {
            globalThreadMaxPoolSize = 2;
        }
        ActiveMQClient.globalScheduledThreadPoolSize = globalScheduledThreadPoolSize;
        globalThreadPoolSize = globalThreadMaxPoolSize;
        ActiveMQClient.globalFlowControlThreadPoolSize = globalFlowControlThreadPoolSize;
    }

    public static ServerLocator createServerLocator(String url) throws Exception {
        ServerLocatorParser parser = new ServerLocatorParser();
        return (ServerLocator)parser.newObject(parser.expandURI(url), null);
    }

    public static ServerLocator createServerLocatorWithoutHA(TransportConfiguration ... transportConfigurations) {
        return new ServerLocatorImpl(false, transportConfigurations);
    }

    public static ServerLocator createServerLocator(boolean ha, TransportConfiguration ... transportConfigurations) {
        return new ServerLocatorImpl(ha, transportConfigurations);
    }

    public static ServerLocator createServerLocatorWithoutHA(DiscoveryGroupConfiguration groupConfiguration) {
        return new ServerLocatorImpl(false, groupConfiguration);
    }

    public static ServerLocator createServerLocator(boolean ha, DiscoveryGroupConfiguration groupConfiguration) {
        return new ServerLocatorImpl(ha, groupConfiguration);
    }

    public static ServerLocator createServerLocatorWithHA(TransportConfiguration ... initialServers) {
        return new ServerLocatorImpl(true, initialServers);
    }

    public static ServerLocator createServerLocatorWithHA(DiscoveryGroupConfiguration groupConfiguration) {
        return new ServerLocatorImpl(true, groupConfiguration);
    }

    private ActiveMQClient() {
    }

    static {
        DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME = RoundRobinConnectionLoadBalancingPolicy.class.getCanonicalName();
        DEFAULT_CLIENT_FAILURE_CHECK_PERIOD = ActiveMQDefaultConfiguration.getDefaultClientFailureCheckPeriod();
        DEFAULT_CONNECTION_TTL = ActiveMQDefaultConfiguration.getDefaultConnectionTtl();
        DEFAULT_RETRY_INTERVAL_MULTIPLIER = ActiveMQDefaultConfiguration.getDefaultRetryIntervalMultiplier();
        DEFAULT_MAX_RETRY_INTERVAL = ActiveMQDefaultConfiguration.getDefaultMaxRetryInterval();
        DEFAULT_GLOBAL_THREAD_POOL_MAX_SIZE = 8 * Runtime.getRuntime().availableProcessors();
        injectedPools = false;
        ActiveMQClient.initializeGlobalThreadPoolProperties();
    }
}

