/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import java.io.Serializable;
import org.apache.james.mailbox.model.MailboxId;

public class InMemoryId
implements MailboxId,
Serializable {
    private final long value;

    public static InMemoryId of(long value) {
        return new InMemoryId(value);
    }

    private InMemoryId(long value) {
        this.value = value;
    }

    public String serialize() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public long getRawId() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InMemoryId other = (InMemoryId)obj;
        return this.value == other.value;
    }

    public static class Factory
    implements MailboxId.Factory {
        public MailboxId fromString(String serialized) {
            return InMemoryId.of(Long.parseLong(serialized));
        }
    }
}

