/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Comparator;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.DocComparator;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.search.comparators.FloatComparator;
import org.apache.lucene.search.comparators.IntComparator;
import org.apache.lucene.search.comparators.LongComparator;
import org.apache.lucene.search.comparators.TermOrdValComparator;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class SortField {
    public static final SortField FIELD_SCORE = new SortField(null, Type.SCORE);
    public static final SortField FIELD_DOC = new SortField(null, Type.DOC);
    private String field;
    private Type type;
    boolean reverse = false;
    private FieldComparatorSource comparatorSource;
    protected Object missingValue = null;
    @Deprecated
    private boolean optimizeSortWithIndexedData = true;
    public static final Object STRING_FIRST = new Object(){

        public String toString() {
            return "SortField.STRING_FIRST";
        }
    };
    public static final Object STRING_LAST = new Object(){

        public String toString() {
            return "SortField.STRING_LAST";
        }
    };
    private Comparator<BytesRef> bytesComparator = Comparator.naturalOrder();

    public SortField(String field, Type type) {
        this.initFieldType(field, type);
    }

    public SortField(String field, Type type, boolean reverse) {
        this.initFieldType(field, type);
        this.reverse = reverse;
    }

    protected static Type readType(DataInput in) throws IOException {
        String type = in.readString();
        try {
            return Type.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't deserialize SortField - unknown type " + type, e);
        }
    }

    private void serialize(DataOutput out) throws IOException {
        out.writeString(this.field);
        out.writeString(this.type.toString());
        out.writeInt(this.reverse ? 1 : 0);
        if (this.missingValue == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            switch (this.type.ordinal()) {
                case 2: {
                    if (this.missingValue == STRING_LAST) {
                        out.writeInt(0);
                        break;
                    }
                    if (this.missingValue == STRING_FIRST) {
                        out.writeInt(1);
                        break;
                    }
                    throw new IllegalArgumentException("Cannot serialize missing value of " + String.valueOf(this.missingValue) + " for type STRING");
                }
                case 3: {
                    out.writeInt((Integer)this.missingValue);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.missingValue);
                    break;
                }
                case 4: {
                    out.writeInt(NumericUtils.floatToSortableInt(((Float)this.missingValue).floatValue()));
                    break;
                }
                case 6: {
                    out.writeLong(NumericUtils.doubleToSortableLong((Double)this.missingValue));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot serialize SortField of type " + String.valueOf((Object)this.type));
                }
            }
        }
    }

    public Object getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(Object missingValue) {
        if (this.type == Type.STRING || this.type == Type.STRING_VAL) {
            if (missingValue != STRING_FIRST && missingValue != STRING_LAST) {
                throw new IllegalArgumentException("For STRING type, missing value must be either STRING_FIRST or STRING_LAST");
            }
        } else if (this.type == Type.INT) {
            if (missingValue != null && missingValue.getClass() != Integer.class) {
                throw new IllegalArgumentException("Missing values for Type.INT can only be of type java.lang.Integer, but got " + String.valueOf(missingValue.getClass()));
            }
        } else if (this.type == Type.LONG) {
            if (missingValue != null && missingValue.getClass() != Long.class) {
                throw new IllegalArgumentException("Missing values for Type.LONG can only be of type java.lang.Long, but got " + String.valueOf(missingValue.getClass()));
            }
        } else if (this.type == Type.FLOAT) {
            if (missingValue != null && missingValue.getClass() != Float.class) {
                throw new IllegalArgumentException("Missing values for Type.FLOAT can only be of type java.lang.Float, but got " + String.valueOf(missingValue.getClass()));
            }
        } else if (this.type == Type.DOUBLE) {
            if (missingValue != null && missingValue.getClass() != Double.class) {
                throw new IllegalArgumentException("Missing values for Type.DOUBLE can only be of type java.lang.Double, but got " + String.valueOf(missingValue.getClass()));
            }
        } else {
            throw new IllegalArgumentException("Missing value only works for numeric or STRING types");
        }
        this.missingValue = missingValue;
    }

    public SortField(String field, FieldComparatorSource comparator) {
        this.initFieldType(field, Type.CUSTOM);
        this.comparatorSource = comparator;
    }

    public SortField(String field, FieldComparatorSource comparator, boolean reverse) {
        this.initFieldType(field, Type.CUSTOM);
        this.reverse = reverse;
        this.comparatorSource = comparator;
    }

    private void initFieldType(String field, Type type) {
        this.type = type;
        if (field == null) {
            if (type != Type.SCORE && type != Type.DOC) {
                throw new IllegalArgumentException("field can only be null when type is SCORE or DOC");
            }
        } else {
            this.field = field;
        }
    }

    public String getField() {
        return this.field;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public FieldComparatorSource getComparatorSource() {
        return this.comparatorSource;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        switch (this.type.ordinal()) {
            case 0: {
                buffer.append("<score>");
                break;
            }
            case 1: {
                buffer.append("<doc>");
                break;
            }
            case 2: {
                buffer.append("<string: \"").append(this.field).append("\">");
                break;
            }
            case 8: {
                buffer.append("<string_val: \"").append(this.field).append("\">");
                break;
            }
            case 3: {
                buffer.append("<int: \"").append(this.field).append("\">");
                break;
            }
            case 5: {
                buffer.append("<long: \"").append(this.field).append("\">");
                break;
            }
            case 4: {
                buffer.append("<float: \"").append(this.field).append("\">");
                break;
            }
            case 6: {
                buffer.append("<double: \"").append(this.field).append("\">");
                break;
            }
            case 7: {
                buffer.append("<custom:\"").append(this.field).append("\": ").append(this.comparatorSource).append('>');
                break;
            }
            case 9: {
                buffer.append("<rewriteable: \"").append(this.field).append("\">");
                break;
            }
            default: {
                buffer.append("<???: \"").append(this.field).append("\">");
            }
        }
        if (this.reverse) {
            buffer.append('!');
        }
        if (this.missingValue != null) {
            buffer.append(" missingValue=");
            buffer.append(this.missingValue);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)o;
        return Objects.equals(other.field, this.field) && other.type == this.type && other.reverse == this.reverse && Objects.equals(this.comparatorSource, other.comparatorSource) && Objects.equals(this.missingValue, other.missingValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.type, this.reverse, this.comparatorSource, this.missingValue});
    }

    public void setBytesComparator(Comparator<BytesRef> b) {
        this.bytesComparator = b;
    }

    public Comparator<BytesRef> getBytesComparator() {
        return this.bytesComparator;
    }

    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        FieldComparator fieldComparator = switch (this.type.ordinal()) {
            case 0 -> new FieldComparator.RelevanceComparator(numHits);
            case 1 -> new DocComparator(numHits, this.reverse, pruning);
            case 3 -> new IntComparator(numHits, this.field, (Integer)this.missingValue, this.reverse, pruning);
            case 4 -> new FloatComparator(numHits, this.field, (Float)this.missingValue, this.reverse, pruning);
            case 5 -> new LongComparator(numHits, this.field, (Long)this.missingValue, this.reverse, pruning);
            case 6 -> new DoubleComparator(numHits, this.field, (Double)this.missingValue, this.reverse, pruning);
            case 7 -> {
                if (!$assertionsDisabled && this.comparatorSource == null) {
                    throw new AssertionError();
                }
                yield this.comparatorSource.newComparator(this.field, numHits, pruning, this.reverse);
            }
            case 2 -> new TermOrdValComparator(numHits, this.field, this.missingValue == STRING_LAST, this.reverse, pruning);
            case 8 -> new FieldComparator.TermValComparator(numHits, this.field, this.missingValue == STRING_LAST);
            case 9 -> throw new IllegalStateException("SortField needs to be rewritten through Sort.rewrite(..) and SortField.rewrite(..)");
            default -> throw new IllegalStateException("Illegal sort type: " + String.valueOf((Object)this.type));
        };
        if (!this.getOptimizeSortWithIndexedData()) {
            fieldComparator.disableSkipping();
        }
        return fieldComparator;
    }

    public SortField rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    public boolean needsScores() {
        return this.type == Type.SCORE;
    }

    public IndexSorter getIndexSorter() {
        switch (this.type.ordinal()) {
            case 2: {
                return new IndexSorter.StringSorter("SortField", this.missingValue, this.reverse, reader -> DocValues.getSorted(reader, this.field));
            }
            case 3: {
                return new IndexSorter.IntSorter("SortField", (Integer)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
            case 5: {
                return new IndexSorter.LongSorter("SortField", (Long)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
            case 6: {
                return new IndexSorter.DoubleSorter("SortField", (Double)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
            case 4: {
                return new IndexSorter.FloatSorter("SortField", (Float)this.missingValue, this.reverse, reader -> DocValues.getNumeric(reader, this.field));
            }
        }
        return null;
    }

    @Deprecated
    public void setOptimizeSortWithIndexedData(boolean optimizeSortWithIndexedData) {
        this.optimizeSortWithIndexedData = optimizeSortWithIndexedData;
    }

    @Deprecated
    public boolean getOptimizeSortWithIndexedData() {
        return this.optimizeSortWithIndexedData;
    }

    @Deprecated
    public void setOptimizeSortWithPoints(boolean optimizeSortWithPoints) {
        this.setOptimizeSortWithIndexedData(optimizeSortWithPoints);
    }

    @Deprecated
    public boolean getOptimizeSortWithPoints() {
        return this.getOptimizeSortWithIndexedData();
    }

    public static enum Type {
        SCORE,
        DOC,
        STRING,
        INT,
        FLOAT,
        LONG,
        DOUBLE,
        CUSTOM,
        STRING_VAL,
        REWRITEABLE;

    }

    public static final class Provider
    extends SortFieldProvider {
        public static final String NAME = "SortField";

        public Provider() {
            super(NAME);
        }

        @Override
        public SortField readSortField(DataInput in) throws IOException {
            SortField sf = new SortField(in.readString(), SortField.readType(in), in.readInt() == 1);
            if (in.readInt() == 1) {
                switch (sf.type.ordinal()) {
                    case 2: {
                        int missingString = in.readInt();
                        if (missingString == 1) {
                            sf.setMissingValue(STRING_FIRST);
                            break;
                        }
                        sf.setMissingValue(STRING_LAST);
                        break;
                    }
                    case 3: {
                        sf.setMissingValue(in.readInt());
                        break;
                    }
                    case 5: {
                        sf.setMissingValue(in.readLong());
                        break;
                    }
                    case 4: {
                        sf.setMissingValue(Float.valueOf(NumericUtils.sortableIntToFloat(in.readInt())));
                        break;
                    }
                    case 6: {
                        sf.setMissingValue(NumericUtils.sortableLongToDouble(in.readLong()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot deserialize sort of type " + String.valueOf((Object)sf.type));
                    }
                }
            }
            return sf;
        }

        @Override
        public void writeSortField(SortField sf, DataOutput out) throws IOException {
            sf.serialize(out);
        }
    }
}

