/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public enum BinarySizeUnit {
    BYTES(BigInteger.valueOf(1L), UtilityMessages.INFO_SIZE_UNIT_BYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_BYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_BYTES_ABBREVIATION.get()),
    KILOBYTES(BigInteger.valueOf(1024L), UtilityMessages.INFO_SIZE_UNIT_KILOBYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_KILOBYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_KILOBYTES_ABBREVIATION.get()),
    MEGABYTES(BigInteger.valueOf(0x100000L), UtilityMessages.INFO_SIZE_UNIT_MEGABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_MEGABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_MEGABYTES_ABBREVIATION.get()),
    GIGABYTES(BigInteger.valueOf(0x40000000L), UtilityMessages.INFO_SIZE_UNIT_GIGABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_GIGABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_GIGABYTES_ABBREVIATION.get()),
    TERABYTES(BigInteger.valueOf(0x10000000000L), UtilityMessages.INFO_SIZE_UNIT_TERABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_TERABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_TERABYTES_ABBREVIATION.get()),
    PETABYTES(BigInteger.valueOf(0x4000000000000L), UtilityMessages.INFO_SIZE_UNIT_PETABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_PETABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_PETABYTES_ABBREVIATION.get()),
    EXABYTES(new BigInteger("1152921504606846976"), UtilityMessages.INFO_SIZE_UNIT_EXABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_EXABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_EXABYTES_ABBREVIATION.get()),
    ZETTABYTES(new BigInteger("1180591620717411303424"), UtilityMessages.INFO_SIZE_UNIT_ZETTABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_ZETTABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_ZETTABYTES_ABBREVIATION.get()),
    YOTTABYTES(new BigInteger("1208925819614629174706176"), UtilityMessages.INFO_SIZE_UNIT_YOTTABYTES_SINGULAR.get(), UtilityMessages.INFO_SIZE_UNIT_YOTTABYTES_PLURAL.get(), UtilityMessages.INFO_SIZE_UNIT_YOTTABYTES_ABBREVIATION.get());

    @NotNull
    private final BigInteger numBytesPerUnit;
    @NotNull
    private final String abbreviation;
    @NotNull
    private final String pluralName;
    @NotNull
    private final String singularName;

    private BinarySizeUnit(@NotNull BigInteger numBytesPerUnit, @NotNull String singularName, String pluralName, String abbreviation) {
        this.numBytesPerUnit = numBytesPerUnit;
        this.singularName = singularName;
        this.pluralName = pluralName;
        this.abbreviation = abbreviation;
    }

    @NotNull
    public BigInteger getNumBytesPerUnit() {
        return this.numBytesPerUnit;
    }

    @NotNull
    public String getSingularName() {
        return this.singularName;
    }

    @NotNull
    public String getPluralName() {
        return this.pluralName;
    }

    @NotNull
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @NotNull
    public BigInteger toBytes(long value) {
        return this.toBytes(BigInteger.valueOf(value));
    }

    @NotNull
    public BigInteger toBytes(@NotNull BigInteger value) {
        return this.numBytesPerUnit.multiply(value);
    }

    @NotNull
    public BigInteger toBytes(double value) {
        return this.toBytes(BigDecimal.valueOf(value));
    }

    @NotNull
    public BigInteger toBytes(@NotNull BigDecimal value) {
        BigDecimal numBytesPerUnitAsBigDecimal = new BigDecimal(this.numBytesPerUnit);
        BigDecimal numBytesBigDecimal = numBytesPerUnitAsBigDecimal.multiply(value);
        BigDecimal roundedBigDecimal = numBytesBigDecimal.setScale(0, RoundingMode.HALF_UP);
        return roundedBigDecimal.toBigInteger();
    }

    @NotNull
    public BigDecimal fromBytes(long numBytes) {
        return this.fromBytes(BigInteger.valueOf(numBytes));
    }

    @NotNull
    public BigDecimal fromBytes(@NotNull BigInteger numBytes) {
        BigDecimal numBytesPerUnitAsBigDecimal = new BigDecimal(this.numBytesPerUnit);
        BigDecimal numBytesAsBigDecimal = new BigDecimal(numBytes);
        return numBytesAsBigDecimal.divide(numBytesPerUnitAsBigDecimal);
    }

    @NotNull
    public static String bytesToHumanReadableSize(long numBytes) {
        return BinarySizeUnit.bytesToHumanReadableSize(BigInteger.valueOf(numBytes));
    }

    @NotNull
    public static String bytesToHumanReadableSize(@NotNull BigInteger numBytes) {
        Validator.ensureTrue(numBytes.compareTo(BigInteger.ZERO) >= 0, "BinarySizeUnits.bytesToHumanReadableSize.numBytes must be greater than or equal to zero.");
        BinarySizeUnit selectedUnit = null;
        BinarySizeUnit[] values = BinarySizeUnit.values();
        for (int i = values.length - 1; i >= 0; --i) {
            BinarySizeUnit unit = values[i];
            if (numBytes.compareTo(unit.numBytesPerUnit) < 0) continue;
            selectedUnit = unit;
            break;
        }
        if (selectedUnit == null) {
            return numBytes + BinarySizeUnit.BYTES.abbreviation;
        }
        if (numBytes.remainder(selectedUnit.numBytesPerUnit).equals(BigInteger.ZERO)) {
            return numBytes.divide(selectedUnit.numBytesPerUnit) + selectedUnit.abbreviation;
        }
        BigDecimal numBytesAsBigDecimal = new BigDecimal(numBytes);
        BigDecimal numBytesPerUnitAsBigDecimal = new BigDecimal(selectedUnit.numBytesPerUnit);
        BigDecimal numUnitsPerValueAsBigDecimal = numBytesAsBigDecimal.divide(numBytesPerUnitAsBigDecimal, 2, RoundingMode.HALF_UP);
        return numUnitsPerValueAsBigDecimal.toString() + selectedUnit.abbreviation;
    }

    @Nullable
    public static BinarySizeUnit forName(@NotNull String name) {
        for (BinarySizeUnit unit : BinarySizeUnit.values()) {
            if (!name.equalsIgnoreCase(unit.name()) && !name.equalsIgnoreCase(unit.singularName) && !name.equalsIgnoreCase(unit.pluralName) && !name.equalsIgnoreCase(unit.abbreviation)) continue;
            return unit;
        }
        return null;
    }
}

