/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.IOException;
import java.text.ParseException;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Base64 {
    @NotNull
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    @NotNull
    private static final char[] BASE64URL_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();

    private Base64() {
    }

    @NotNull
    public static String encode(@NotNull String data) {
        Validator.ensureNotNull(data);
        return Base64.encode(StaticUtils.getBytes(data));
    }

    @NotNull
    public static String encode(@NotNull byte[] data) {
        Validator.ensureNotNull(data);
        StringBuilder buffer = new StringBuilder(4 * data.length / 3 + 1);
        Base64.encode(BASE64_ALPHABET, data, 0, data.length, buffer, "=");
        return buffer.toString();
    }

    public static void encode(@NotNull String data, @NotNull StringBuilder buffer) {
        Validator.ensureNotNull(data);
        Base64.encode(StaticUtils.getBytes(data), buffer);
    }

    public static void encode(@NotNull String data, @NotNull ByteStringBuffer buffer) {
        Validator.ensureNotNull(data);
        Base64.encode(StaticUtils.getBytes(data), buffer);
    }

    public static void encode(@NotNull byte[] data, @NotNull StringBuilder buffer) {
        Base64.encode(BASE64_ALPHABET, data, 0, data.length, buffer, "=");
    }

    public static void encode(@NotNull byte[] data, int off, int length, @NotNull StringBuilder buffer) {
        Base64.encode(BASE64_ALPHABET, data, off, length, buffer, "=");
    }

    public static void encode(@NotNull byte[] data, @NotNull ByteStringBuffer buffer) {
        Base64.encode(BASE64_ALPHABET, data, 0, data.length, buffer, "=");
    }

    public static void encode(@NotNull byte[] data, int off, int length, @NotNull ByteStringBuffer buffer) {
        Base64.encode(BASE64_ALPHABET, data, off, length, buffer, "=");
    }

    @NotNull
    public static String urlEncode(@NotNull String data, boolean pad) {
        return Base64.urlEncode(StaticUtils.getBytes(data), pad);
    }

    public static void urlEncode(@NotNull String data, @NotNull StringBuilder buffer, boolean pad) {
        byte[] dataBytes = StaticUtils.getBytes(data);
        Base64.encode(BASE64_ALPHABET, dataBytes, 0, dataBytes.length, buffer, pad ? "%3d" : null);
    }

    public static void urlEncode(@NotNull String data, @NotNull ByteStringBuffer buffer, boolean pad) {
        byte[] dataBytes = StaticUtils.getBytes(data);
        Base64.encode(BASE64_ALPHABET, dataBytes, 0, dataBytes.length, buffer, pad ? "%3d" : null);
    }

    @NotNull
    public static String urlEncode(@NotNull byte[] data, boolean pad) {
        StringBuilder buffer = new StringBuilder(4 * data.length / 3 + 6);
        Base64.encode(BASE64URL_ALPHABET, data, 0, data.length, buffer, pad ? "%3d" : null);
        return buffer.toString();
    }

    public static void urlEncode(@NotNull byte[] data, int off, int length, @NotNull StringBuilder buffer, boolean pad) {
        Base64.encode(BASE64URL_ALPHABET, data, off, length, buffer, pad ? "%3d" : null);
    }

    public static void urlEncode(@NotNull byte[] data, int off, int length, @NotNull ByteStringBuffer buffer, boolean pad) {
        Base64.encode(BASE64URL_ALPHABET, data, off, length, buffer, pad ? "%3d" : null);
    }

    private static void encode(@NotNull char[] alphabet, @NotNull byte[] data, int off, int length, @NotNull Appendable buffer, @Nullable String padStr) {
        Validator.ensureNotNull(data);
        Validator.ensureTrue(data.length >= off);
        Validator.ensureTrue(data.length >= off + length);
        if (length == 0) {
            return;
        }
        try {
            int pos = off;
            for (int i = 0; i < length / 3; ++i) {
                int intValue = (data[pos++] & 0xFF) << 16 | (data[pos++] & 0xFF) << 8 | data[pos++] & 0xFF;
                buffer.append(alphabet[intValue >> 18 & 0x3F]);
                buffer.append(alphabet[intValue >> 12 & 0x3F]);
                buffer.append(alphabet[intValue >> 6 & 0x3F]);
                buffer.append(alphabet[intValue & 0x3F]);
            }
            switch (off + length - pos) {
                case 1: {
                    int intValue = (data[pos] & 0xFF) << 16;
                    buffer.append(alphabet[intValue >> 18 & 0x3F]);
                    buffer.append(alphabet[intValue >> 12 & 0x3F]);
                    if (padStr != null) {
                        buffer.append(padStr);
                        buffer.append(padStr);
                    }
                    return;
                }
                case 2: {
                    int intValue = (data[pos++] & 0xFF) << 16 | (data[pos] & 0xFF) << 8;
                    buffer.append(alphabet[intValue >> 18 & 0x3F]);
                    buffer.append(alphabet[intValue >> 12 & 0x3F]);
                    buffer.append(alphabet[intValue >> 6 & 0x3F]);
                    if (padStr != null) {
                        buffer.append(padStr);
                    }
                    return;
                }
            }
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new RuntimeException(ioe.getMessage(), ioe);
        }
    }

    @NotNull
    public static byte[] decode(@NotNull String data) throws ParseException {
        Validator.ensureNotNull(data);
        int length = data.length();
        if (length == 0) {
            return StaticUtils.NO_BYTES;
        }
        if (length % 4 != 0) {
            throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_INVALID_LENGTH.get(), length);
        }
        int numBytes = 3 * (length / 4);
        if (data.charAt(length - 2) == '=') {
            numBytes -= 2;
        } else if (data.charAt(length - 1) == '=') {
            --numBytes;
        }
        byte[] b = new byte[numBytes];
        int stringPos = 0;
        int arrayPos = 0;
        while (stringPos < length) {
            int intValue = 0;
            block72: for (int i = 0; i < 4; ++i) {
                intValue <<= 6;
                switch (data.charAt(stringPos++)) {
                    case 'A': {
                        intValue |= 0;
                        continue block72;
                    }
                    case 'B': {
                        intValue |= 1;
                        continue block72;
                    }
                    case 'C': {
                        intValue |= 2;
                        continue block72;
                    }
                    case 'D': {
                        intValue |= 3;
                        continue block72;
                    }
                    case 'E': {
                        intValue |= 4;
                        continue block72;
                    }
                    case 'F': {
                        intValue |= 5;
                        continue block72;
                    }
                    case 'G': {
                        intValue |= 6;
                        continue block72;
                    }
                    case 'H': {
                        intValue |= 7;
                        continue block72;
                    }
                    case 'I': {
                        intValue |= 8;
                        continue block72;
                    }
                    case 'J': {
                        intValue |= 9;
                        continue block72;
                    }
                    case 'K': {
                        intValue |= 0xA;
                        continue block72;
                    }
                    case 'L': {
                        intValue |= 0xB;
                        continue block72;
                    }
                    case 'M': {
                        intValue |= 0xC;
                        continue block72;
                    }
                    case 'N': {
                        intValue |= 0xD;
                        continue block72;
                    }
                    case 'O': {
                        intValue |= 0xE;
                        continue block72;
                    }
                    case 'P': {
                        intValue |= 0xF;
                        continue block72;
                    }
                    case 'Q': {
                        intValue |= 0x10;
                        continue block72;
                    }
                    case 'R': {
                        intValue |= 0x11;
                        continue block72;
                    }
                    case 'S': {
                        intValue |= 0x12;
                        continue block72;
                    }
                    case 'T': {
                        intValue |= 0x13;
                        continue block72;
                    }
                    case 'U': {
                        intValue |= 0x14;
                        continue block72;
                    }
                    case 'V': {
                        intValue |= 0x15;
                        continue block72;
                    }
                    case 'W': {
                        intValue |= 0x16;
                        continue block72;
                    }
                    case 'X': {
                        intValue |= 0x17;
                        continue block72;
                    }
                    case 'Y': {
                        intValue |= 0x18;
                        continue block72;
                    }
                    case 'Z': {
                        intValue |= 0x19;
                        continue block72;
                    }
                    case 'a': {
                        intValue |= 0x1A;
                        continue block72;
                    }
                    case 'b': {
                        intValue |= 0x1B;
                        continue block72;
                    }
                    case 'c': {
                        intValue |= 0x1C;
                        continue block72;
                    }
                    case 'd': {
                        intValue |= 0x1D;
                        continue block72;
                    }
                    case 'e': {
                        intValue |= 0x1E;
                        continue block72;
                    }
                    case 'f': {
                        intValue |= 0x1F;
                        continue block72;
                    }
                    case 'g': {
                        intValue |= 0x20;
                        continue block72;
                    }
                    case 'h': {
                        intValue |= 0x21;
                        continue block72;
                    }
                    case 'i': {
                        intValue |= 0x22;
                        continue block72;
                    }
                    case 'j': {
                        intValue |= 0x23;
                        continue block72;
                    }
                    case 'k': {
                        intValue |= 0x24;
                        continue block72;
                    }
                    case 'l': {
                        intValue |= 0x25;
                        continue block72;
                    }
                    case 'm': {
                        intValue |= 0x26;
                        continue block72;
                    }
                    case 'n': {
                        intValue |= 0x27;
                        continue block72;
                    }
                    case 'o': {
                        intValue |= 0x28;
                        continue block72;
                    }
                    case 'p': {
                        intValue |= 0x29;
                        continue block72;
                    }
                    case 'q': {
                        intValue |= 0x2A;
                        continue block72;
                    }
                    case 'r': {
                        intValue |= 0x2B;
                        continue block72;
                    }
                    case 's': {
                        intValue |= 0x2C;
                        continue block72;
                    }
                    case 't': {
                        intValue |= 0x2D;
                        continue block72;
                    }
                    case 'u': {
                        intValue |= 0x2E;
                        continue block72;
                    }
                    case 'v': {
                        intValue |= 0x2F;
                        continue block72;
                    }
                    case 'w': {
                        intValue |= 0x30;
                        continue block72;
                    }
                    case 'x': {
                        intValue |= 0x31;
                        continue block72;
                    }
                    case 'y': {
                        intValue |= 0x32;
                        continue block72;
                    }
                    case 'z': {
                        intValue |= 0x33;
                        continue block72;
                    }
                    case '0': {
                        intValue |= 0x34;
                        continue block72;
                    }
                    case '1': {
                        intValue |= 0x35;
                        continue block72;
                    }
                    case '2': {
                        intValue |= 0x36;
                        continue block72;
                    }
                    case '3': {
                        intValue |= 0x37;
                        continue block72;
                    }
                    case '4': {
                        intValue |= 0x38;
                        continue block72;
                    }
                    case '5': {
                        intValue |= 0x39;
                        continue block72;
                    }
                    case '6': {
                        intValue |= 0x3A;
                        continue block72;
                    }
                    case '7': {
                        intValue |= 0x3B;
                        continue block72;
                    }
                    case '8': {
                        intValue |= 0x3C;
                        continue block72;
                    }
                    case '9': {
                        intValue |= 0x3D;
                        continue block72;
                    }
                    case '+': {
                        intValue |= 0x3E;
                        continue block72;
                    }
                    case '/': {
                        intValue |= 0x3F;
                        continue block72;
                    }
                    case '=': {
                        switch (length - stringPos) {
                            case 0: {
                                b[arrayPos++] = (byte)((intValue >>= 8) >> 8 & 0xFF);
                                b[arrayPos] = (byte)(intValue & 0xFF);
                                return b;
                            }
                            case 1: {
                                b[arrayPos] = (byte)((intValue >>= 10) & 0xFF);
                                return b;
                            }
                        }
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_EQUAL.get(stringPos - 1), stringPos - 1);
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_CHAR.get(Character.valueOf(data.charAt(stringPos - 1))), stringPos - 1);
                    }
                }
            }
            b[arrayPos++] = (byte)(intValue >> 16 & 0xFF);
            b[arrayPos++] = (byte)(intValue >> 8 & 0xFF);
            b[arrayPos++] = (byte)(intValue & 0xFF);
        }
        return b;
    }

    @NotNull
    public static String decodeToString(@NotNull String data) throws ParseException {
        Validator.ensureNotNull(data);
        byte[] decodedBytes = Base64.decode(data);
        return StaticUtils.toUTF8String(decodedBytes);
    }

    @NotNull
    public static byte[] urlDecode(@NotNull String data) throws ParseException {
        Validator.ensureNotNull(data);
        int length = data.length();
        if (length == 0) {
            return StaticUtils.NO_BYTES;
        }
        int stringPos = 0;
        ByteStringBuffer buffer = new ByteStringBuffer(length);
        block71: while (stringPos < length) {
            int intValue = 0;
            block72: for (int i = 0; i < 4; ++i) {
                int c;
                if (stringPos >= length) {
                    c = 61;
                    ++stringPos;
                } else {
                    c = data.charAt(stringPos++);
                }
                intValue <<= 6;
                switch (c) {
                    case 65: {
                        intValue |= 0;
                        continue block72;
                    }
                    case 66: {
                        intValue |= 1;
                        continue block72;
                    }
                    case 67: {
                        intValue |= 2;
                        continue block72;
                    }
                    case 68: {
                        intValue |= 3;
                        continue block72;
                    }
                    case 69: {
                        intValue |= 4;
                        continue block72;
                    }
                    case 70: {
                        intValue |= 5;
                        continue block72;
                    }
                    case 71: {
                        intValue |= 6;
                        continue block72;
                    }
                    case 72: {
                        intValue |= 7;
                        continue block72;
                    }
                    case 73: {
                        intValue |= 8;
                        continue block72;
                    }
                    case 74: {
                        intValue |= 9;
                        continue block72;
                    }
                    case 75: {
                        intValue |= 0xA;
                        continue block72;
                    }
                    case 76: {
                        intValue |= 0xB;
                        continue block72;
                    }
                    case 77: {
                        intValue |= 0xC;
                        continue block72;
                    }
                    case 78: {
                        intValue |= 0xD;
                        continue block72;
                    }
                    case 79: {
                        intValue |= 0xE;
                        continue block72;
                    }
                    case 80: {
                        intValue |= 0xF;
                        continue block72;
                    }
                    case 81: {
                        intValue |= 0x10;
                        continue block72;
                    }
                    case 82: {
                        intValue |= 0x11;
                        continue block72;
                    }
                    case 83: {
                        intValue |= 0x12;
                        continue block72;
                    }
                    case 84: {
                        intValue |= 0x13;
                        continue block72;
                    }
                    case 85: {
                        intValue |= 0x14;
                        continue block72;
                    }
                    case 86: {
                        intValue |= 0x15;
                        continue block72;
                    }
                    case 87: {
                        intValue |= 0x16;
                        continue block72;
                    }
                    case 88: {
                        intValue |= 0x17;
                        continue block72;
                    }
                    case 89: {
                        intValue |= 0x18;
                        continue block72;
                    }
                    case 90: {
                        intValue |= 0x19;
                        continue block72;
                    }
                    case 97: {
                        intValue |= 0x1A;
                        continue block72;
                    }
                    case 98: {
                        intValue |= 0x1B;
                        continue block72;
                    }
                    case 99: {
                        intValue |= 0x1C;
                        continue block72;
                    }
                    case 100: {
                        intValue |= 0x1D;
                        continue block72;
                    }
                    case 101: {
                        intValue |= 0x1E;
                        continue block72;
                    }
                    case 102: {
                        intValue |= 0x1F;
                        continue block72;
                    }
                    case 103: {
                        intValue |= 0x20;
                        continue block72;
                    }
                    case 104: {
                        intValue |= 0x21;
                        continue block72;
                    }
                    case 105: {
                        intValue |= 0x22;
                        continue block72;
                    }
                    case 106: {
                        intValue |= 0x23;
                        continue block72;
                    }
                    case 107: {
                        intValue |= 0x24;
                        continue block72;
                    }
                    case 108: {
                        intValue |= 0x25;
                        continue block72;
                    }
                    case 109: {
                        intValue |= 0x26;
                        continue block72;
                    }
                    case 110: {
                        intValue |= 0x27;
                        continue block72;
                    }
                    case 111: {
                        intValue |= 0x28;
                        continue block72;
                    }
                    case 112: {
                        intValue |= 0x29;
                        continue block72;
                    }
                    case 113: {
                        intValue |= 0x2A;
                        continue block72;
                    }
                    case 114: {
                        intValue |= 0x2B;
                        continue block72;
                    }
                    case 115: {
                        intValue |= 0x2C;
                        continue block72;
                    }
                    case 116: {
                        intValue |= 0x2D;
                        continue block72;
                    }
                    case 117: {
                        intValue |= 0x2E;
                        continue block72;
                    }
                    case 118: {
                        intValue |= 0x2F;
                        continue block72;
                    }
                    case 119: {
                        intValue |= 0x30;
                        continue block72;
                    }
                    case 120: {
                        intValue |= 0x31;
                        continue block72;
                    }
                    case 121: {
                        intValue |= 0x32;
                        continue block72;
                    }
                    case 122: {
                        intValue |= 0x33;
                        continue block72;
                    }
                    case 48: {
                        intValue |= 0x34;
                        continue block72;
                    }
                    case 49: {
                        intValue |= 0x35;
                        continue block72;
                    }
                    case 50: {
                        intValue |= 0x36;
                        continue block72;
                    }
                    case 51: {
                        intValue |= 0x37;
                        continue block72;
                    }
                    case 52: {
                        intValue |= 0x38;
                        continue block72;
                    }
                    case 53: {
                        intValue |= 0x39;
                        continue block72;
                    }
                    case 54: {
                        intValue |= 0x3A;
                        continue block72;
                    }
                    case 55: {
                        intValue |= 0x3B;
                        continue block72;
                    }
                    case 56: {
                        intValue |= 0x3C;
                        continue block72;
                    }
                    case 57: {
                        intValue |= 0x3D;
                        continue block72;
                    }
                    case 45: {
                        intValue |= 0x3E;
                        continue block72;
                    }
                    case 95: {
                        intValue |= 0x3F;
                        continue block72;
                    }
                    case 37: 
                    case 61: {
                        switch ((stringPos - 1) % 4) {
                            case 2: {
                                buffer.append((byte)((intValue >>= 10) & 0xFF));
                                break block71;
                            }
                            case 3: {
                                buffer.append((byte)((intValue >>= 8) >> 8 & 0xFF));
                                buffer.append((byte)(intValue & 0xFF));
                                break block71;
                            }
                            default: {
                                throw new ParseException(UtilityMessages.ERR_BASE64_URLDECODE_INVALID_LENGTH.get(), stringPos - 1);
                            }
                        }
                    }
                    default: {
                        throw new ParseException(UtilityMessages.ERR_BASE64_DECODE_UNEXPECTED_CHAR.get(Character.valueOf(data.charAt(stringPos - 1))), stringPos - 1);
                    }
                }
            }
            buffer.append((byte)(intValue >> 16 & 0xFF));
            buffer.append((byte)(intValue >> 8 & 0xFF));
            buffer.append((byte)(intValue & 0xFF));
        }
        return buffer.toByteArray();
    }

    @NotNull
    public static String urlDecodeToString(@NotNull String data) throws ParseException {
        Validator.ensureNotNull(data);
        byte[] decodedBytes = Base64.urlDecode(data);
        return StaticUtils.toUTF8String(decodedBytes);
    }
}

