/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogField;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextLogMessages;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public class TextFormattedLogMessage
implements LogMessage {
    @NotNull
    protected static final String NO_FIELD_NAME = "";
    @NotNull
    static final String TIMESTAMP_FORMAT_SECOND = "'['dd/MMM/yyyy:HH:mm:ss Z']'";
    @NotNull
    static final String TIMESTAMP_FORMAT_MILLISECOND = "'['dd/MMM/yyyy:HH:mm:ss.SSS Z']'";
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> MILLISECOND_DATE_FORMATTERS = new ThreadLocal();
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> SECOND_DATE_FORMATTERS = new ThreadLocal();
    private static final long serialVersionUID = -8953179308642786675L;
    private final long timestampValue;
    @NotNull
    private final Map<String, List<String>> logFields;
    @NotNull
    private final String logMessageString;

    protected TextFormattedLogMessage(@NotNull TextFormattedLogMessage message) {
        this.timestampValue = message.timestampValue;
        this.logFields = message.logFields;
        this.logMessageString = message.logMessageString;
    }

    public TextFormattedLogMessage(@NotNull String logMessageString) throws LogException {
        this.logMessageString = logMessageString;
        int closeBracketPos = logMessageString.indexOf(93);
        if (closeBracketPos <= 0 || !logMessageString.startsWith("[")) {
            throw new LogException(logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_MISSING_TIMESTAMP.get(logMessageString));
        }
        String timestampString = logMessageString.substring(0, closeBracketPos + 1);
        try {
            SimpleDateFormat dateFormat = TextFormattedLogMessage.getDateFormat(timestampString.indexOf(46) > 0);
            Date timestampDate = dateFormat.parse(timestampString);
            this.timestampValue = timestampDate.getTime();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_MISSING_TIMESTAMP.get(logMessageString), e);
        }
        this.logFields = TextFormattedLogMessage.parseFields(logMessageString, closeBracketPos + 1);
    }

    @NotNull
    private static SimpleDateFormat getDateFormat(boolean millisecondPrecision) {
        if (millisecondPrecision) {
            SimpleDateFormat dateFormat = MILLISECOND_DATE_FORMATTERS.get();
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT_MILLISECOND);
                dateFormat.setLenient(false);
                MILLISECOND_DATE_FORMATTERS.set(dateFormat);
            }
            return dateFormat;
        }
        SimpleDateFormat dateFormat = SECOND_DATE_FORMATTERS.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT_SECOND);
            dateFormat.setLenient(false);
            SECOND_DATE_FORMATTERS.set(dateFormat);
        }
        return dateFormat;
    }

    @NotNull
    private static Map<String, List<String>> parseFields(@NotNull String s, int startPos) throws LogException {
        LinkedHashMap<String, List<String>> fieldMap = new LinkedHashMap<String, List<String>>();
        boolean inQuotes = false;
        StringBuilder buffer = new StringBuilder();
        for (int p = startPos; p < s.length(); ++p) {
            char c = s.charAt(p);
            if (c == ' ' && !inQuotes) {
                if (buffer.length() <= 0) continue;
                TextFormattedLogMessage.processField(s, buffer.toString(), fieldMap);
                buffer.setLength(0);
                continue;
            }
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            TextFormattedLogMessage.processField(s, buffer.toString(), fieldMap);
        }
        return Collections.unmodifiableMap(fieldMap);
    }

    private static void processField(@NotNull String logMessageString, @NotNull String fieldString, @NotNull Map<String, List<String>> fieldMap) throws LogException {
        String fieldValue;
        String fieldName;
        int equalPos = fieldString.indexOf(61);
        if (equalPos < 0) {
            fieldName = NO_FIELD_NAME;
            fieldValue = TextFormattedLogMessage.processValue(logMessageString, fieldString);
        } else {
            fieldName = fieldString.substring(0, equalPos);
            fieldValue = TextFormattedLogMessage.processValue(logMessageString, fieldString.substring(equalPos + 1));
        }
        List<String> values = fieldMap.get(fieldName);
        if (values == null) {
            fieldMap.put(fieldName, Collections.singletonList(fieldValue));
        } else {
            ArrayList<String> updatedValues = new ArrayList<String>(values.size() + 1);
            updatedValues.addAll(values);
            updatedValues.add(fieldValue);
            fieldMap.put(fieldName, Collections.unmodifiableList(updatedValues));
        }
    }

    @NotNull
    private static String processValue(@NotNull String logMessageString, @NotNull String valueString) throws LogException {
        ByteStringBuffer b = new ByteStringBuffer();
        for (int i = 0; i < valueString.length(); ++i) {
            char c = valueString.charAt(i);
            if (c == '\"') continue;
            if (c == '#') {
                if (i > valueString.length() - 3) {
                    throw new LogException(logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER.get(valueString, logMessageString));
                }
                byte rawByte = 0;
                block19: for (int j = 0; j < 2; ++j) {
                    rawByte = (byte)(rawByte << 4);
                    switch (valueString.charAt(++i)) {
                        case '0': {
                            continue block19;
                        }
                        case '1': {
                            rawByte = (byte)(rawByte | 1);
                            continue block19;
                        }
                        case '2': {
                            rawByte = (byte)(rawByte | 2);
                            continue block19;
                        }
                        case '3': {
                            rawByte = (byte)(rawByte | 3);
                            continue block19;
                        }
                        case '4': {
                            rawByte = (byte)(rawByte | 4);
                            continue block19;
                        }
                        case '5': {
                            rawByte = (byte)(rawByte | 5);
                            continue block19;
                        }
                        case '6': {
                            rawByte = (byte)(rawByte | 6);
                            continue block19;
                        }
                        case '7': {
                            rawByte = (byte)(rawByte | 7);
                            continue block19;
                        }
                        case '8': {
                            rawByte = (byte)(rawByte | 8);
                            continue block19;
                        }
                        case '9': {
                            rawByte = (byte)(rawByte | 9);
                            continue block19;
                        }
                        case 'A': 
                        case 'a': {
                            rawByte = (byte)(rawByte | 0xA);
                            continue block19;
                        }
                        case 'B': 
                        case 'b': {
                            rawByte = (byte)(rawByte | 0xB);
                            continue block19;
                        }
                        case 'C': 
                        case 'c': {
                            rawByte = (byte)(rawByte | 0xC);
                            continue block19;
                        }
                        case 'D': 
                        case 'd': {
                            rawByte = (byte)(rawByte | 0xD);
                            continue block19;
                        }
                        case 'E': 
                        case 'e': {
                            rawByte = (byte)(rawByte | 0xE);
                            continue block19;
                        }
                        case 'F': 
                        case 'f': {
                            rawByte = (byte)(rawByte | 0xF);
                            continue block19;
                        }
                        default: {
                            throw new LogException(logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER.get(valueString, logMessageString));
                        }
                    }
                }
                b.append(rawByte);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    @Override
    @NotNull
    public final Date getTimestamp() {
        return new Date(this.timestampValue);
    }

    @Override
    @NotNull
    public final Map<String, List<String>> getFields() {
        return this.logFields;
    }

    @Override
    @Nullable
    public final Boolean getBoolean(@NotNull LogField logField) throws LogException {
        String valueString = this.getString(logField);
        if (valueString == null) {
            return null;
        }
        if (valueString.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (valueString.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new LogException(this.logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_VALUE_NOT_BOOLEAN.get(logField.getFieldName(), this.logMessageString));
    }

    @Nullable
    final Boolean getBooleanNoThrow(@NotNull LogField logField) {
        try {
            return this.getBoolean(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Date getGeneralizedTime(@NotNull LogField logField) throws LogException {
        String valueString = this.getString(logField);
        if (valueString == null) {
            return null;
        }
        try {
            return StaticUtils.decodeGeneralizedTime(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(this.logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME.get(logField.getFieldName(), this.logMessageString), e);
        }
    }

    @Nullable
    final Date getGeneralizedTimeNoThrow(@NotNull LogField logField) {
        try {
            return this.getGeneralizedTime(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Double getDouble(@NotNull LogField logField) throws LogException {
        String valueString = this.getString(logField);
        if (valueString == null) {
            return null;
        }
        try {
            return Double.parseDouble(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(this.logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT.get(logField.getFieldName(), this.logMessageString), e);
        }
    }

    @Nullable
    final Double getDoubleNoThrow(@NotNull LogField logField) {
        try {
            return this.getDouble(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Integer getInteger(@NotNull LogField logField) throws LogException {
        String valueString = this.getString(logField);
        if (valueString == null) {
            return null;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(this.logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString), e);
        }
    }

    @Nullable
    final Integer getIntegerNoThrow(@NotNull LogField logField) {
        try {
            return this.getInteger(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Long getLong(@NotNull LogField logField) throws LogException {
        String valueString = this.getString(logField);
        if (valueString == null) {
            return null;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(this.logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_VALUE_NOT_INTEGER.get(logField.getFieldName(), this.logMessageString), e);
        }
    }

    @Nullable
    final Long getLongNoThrow(@NotNull LogField logField) {
        try {
            return this.getLong(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final Date getRFC3339Timestamp(@NotNull LogField logField) throws LogException {
        String valueString = this.getString(logField);
        if (valueString == null) {
            return null;
        }
        try {
            return StaticUtils.decodeRFC3339Time(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LogException(this.logMessageString, TextLogMessages.ERR_TEXT_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIMESTAMP.get(logField.getFieldName(), this.logMessageString), e);
        }
    }

    @Nullable
    final Date getRFC3339TimestampNoThrow(@NotNull LogField logField) {
        try {
            return this.getRFC3339Timestamp(logField);
        }
        catch (LogException e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @Nullable
    public final String getString(@NotNull LogField logField) {
        List<String> values = this.logFields.get(logField.getFieldName());
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @NotNull
    final List<String> getCommaDelimitedStringList(@NotNull LogField logField) {
        String stringValue = this.getString(logField);
        if (stringValue == null || stringValue.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> valueList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
        while (tokenizer.hasMoreTokens()) {
            valueList.add(tokenizer.nextToken().trim());
        }
        return Collections.unmodifiableList(valueList);
    }

    @NotNull
    final Set<String> getCommaDelimitedStringSet(@NotNull LogField logField) {
        String stringValue = this.getString(logField);
        if (stringValue == null || stringValue.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(stringValue, ",");
        while (tokenizer.hasMoreTokens()) {
            valueSet.add(tokenizer.nextToken().trim());
        }
        return Collections.unmodifiableSet(valueSet);
    }

    @Override
    @NotNull
    public final String toString() {
        return this.logMessageString;
    }
}

