/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateKeyStoreContent;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceInterServerCertificateExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplaceInterServerCertificateExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String REPLACE_INTER_SERVER_CERT_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.69";
    private static final byte TYPE_SKIP_CERT_VALIDATION = -112;
    private static final long serialVersionUID = 2244751901271649579L;
    private final boolean skipCertificateValidation;
    @NotNull
    private final ReplaceCertificateKeyStoreContent keyStoreContent;

    public ReplaceInterServerCertificateExtendedRequest(@NotNull ReplaceCertificateKeyStoreContent keyStoreContent, boolean skipCertificateValidation, Control ... requestControls) {
        super(REPLACE_INTER_SERVER_CERT_REQUEST_OID, ReplaceInterServerCertificateExtendedRequest.encodeValue(keyStoreContent, skipCertificateValidation), requestControls);
        this.keyStoreContent = keyStoreContent;
        this.skipCertificateValidation = skipCertificateValidation;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ReplaceCertificateKeyStoreContent keyStoreContent, boolean skipCertificateValidation) {
        Validator.ensureNotNullWithMessage(keyStoreContent, "ReplaceInterServerCertificateExtendedRequest.keyStoreContent must not be null.");
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>();
        elements.add(keyStoreContent.encode());
        if (skipCertificateValidation) {
            elements.add(new ASN1Boolean(-112, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public ReplaceInterServerCertificateExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REPLACE_INTER_SERVER_CERT_REQ_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.keyStoreContent = ReplaceCertificateKeyStoreContent.decode(elements[0]);
            boolean skipValidation = false;
            for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -112: {
                        skipValidation = elements[i].decodeAsBoolean().booleanValue();
                    }
                }
            }
            this.skipCertificateValidation = skipValidation;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REPLACE_INTER_SERVER_CERT_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public ReplaceCertificateKeyStoreContent getKeyStoreContent() {
        return this.keyStoreContent;
    }

    public boolean skipCertificateValidation() {
        return this.skipCertificateValidation;
    }

    @Override
    @NotNull
    public ReplaceInterServerCertificateExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new ReplaceInterServerCertificateExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_REPLACE_INTER_SERVER_CERT_REQUEST_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ReplaceInterServerCertificateExtendedRequest(oid='");
        buffer.append(this.getOID());
        buffer.append("', keyStoreContent=");
        this.keyStoreContent.toString(buffer);
        buffer.append(", skipCertificateValidation=");
        buffer.append(this.skipCertificateValidation);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

