/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@Deprecated
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InteractiveTransactionSpecificationRequestControl
extends Control {
    @NotNull
    public static final String INTERACTIVE_TRANSACTION_SPECIFICATION_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.4";
    private static final byte TYPE_TXN_ID = -128;
    private static final byte TYPE_ABORT_ON_FAILURE = -127;
    private static final byte TYPE_WRITE_LOCK = -126;
    private static final long serialVersionUID = -6473934815135786621L;
    @NotNull
    private final ASN1OctetString transactionID;
    private final boolean abortOnFailure;
    private final boolean writeLock;

    public InteractiveTransactionSpecificationRequestControl(@NotNull ASN1OctetString transactionID) {
        this(transactionID, false, true);
    }

    public InteractiveTransactionSpecificationRequestControl(@NotNull ASN1OctetString transactionID, boolean abortOnFailure, boolean writeLock) {
        super(INTERACTIVE_TRANSACTION_SPECIFICATION_REQUEST_OID, true, InteractiveTransactionSpecificationRequestControl.encodeValue(transactionID, abortOnFailure, writeLock));
        this.transactionID = transactionID;
        this.abortOnFailure = abortOnFailure;
        this.writeLock = writeLock;
    }

    public InteractiveTransactionSpecificationRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1Element[] elements;
        if (!control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element e = ASN1Element.decode(control.getValue().getValue());
            elements = ASN1Sequence.decodeAsSequence(e).elements();
        }
        catch (Exception e) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_REQUEST_VALUE_NOT_SEQUENCE.get(e.getMessage()), e);
        }
        ASN1OctetString txnID = null;
        boolean shouldAbortOnFailure = false;
        boolean shouldWriteLock = true;
        block11: for (ASN1Element element : elements) {
            switch (element.getType()) {
                case -128: {
                    txnID = ASN1OctetString.decodeAsOctetString(element);
                    continue block11;
                }
                case -127: {
                    try {
                        shouldAbortOnFailure = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                        continue block11;
                    }
                    catch (Exception e) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_REQUEST_ABORT_ON_FAILURE_NOT_BOOLEAN.get(e.getMessage()), e);
                    }
                }
                case -126: {
                    try {
                        shouldWriteLock = ASN1Boolean.decodeAsBoolean(element).booleanValue();
                        continue block11;
                    }
                    catch (Exception e) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_REQUEST_WRITE_LOCK_NOT_BOOLEAN.get(e.getMessage()), e);
                    }
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_REQUEST_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(element.getType())));
                }
            }
        }
        if (txnID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_INT_TXN_REQUEST_NO_TXN_ID.get());
        }
        this.transactionID = txnID;
        this.abortOnFailure = shouldAbortOnFailure;
        this.writeLock = shouldWriteLock;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ASN1OctetString transactionID, boolean abortOnFailure, boolean writeLock) {
        Validator.ensureNotNull(transactionID);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1OctetString(-128, transactionID.getValue()));
        if (abortOnFailure) {
            elements.add(new ASN1Boolean(-127, abortOnFailure));
        }
        if (!writeLock) {
            elements.add(new ASN1Boolean(-126, writeLock));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public boolean abortOnFailure() {
        return this.abortOnFailure;
    }

    public boolean writeLock() {
        return this.writeLock;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_INTERACTIVE_TXN_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InteractiveTransactionSpecificationRequestControl(transactionID='");
        buffer.append(this.transactionID.stringValue());
        buffer.append("', abortOnFailure=");
        buffer.append(this.abortOnFailure);
        buffer.append(", writeLock=");
        buffer.append(this.writeLock);
        buffer.append(')');
    }
}

